/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskParams;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.Transform;
import org.elasticsearch.xpack.transform.checkpoint.TransformCheckpointService;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.transforms.ClientTransformIndexer;
import org.elasticsearch.xpack.transform.transforms.ClientTransformIndexerBuilder;
import org.elasticsearch.xpack.transform.transforms.TransformContext;

public class TransformTask
extends AllocatedPersistentTask
implements SchedulerEngine.Listener,
TransformContext.Listener {
    private static final Logger logger = LogManager.getLogger(TransformTask.class);
    private static final IndexerState[] RUNNING_STATES = new IndexerState[]{IndexerState.STARTED, IndexerState.INDEXING};
    public static final String SCHEDULE_NAME = "data_frame/transforms/schedule";
    private final ParentTaskAssigningClient parentTaskClient;
    private final TransformTaskParams transform;
    private final SchedulerEngine schedulerEngine;
    private final ThreadPool threadPool;
    private final TransformAuditor auditor;
    private final TransformIndexerPosition initialPosition;
    private final IndexerState initialIndexerState;
    private final TransformContext context;
    private final SetOnce<ClientTransformIndexer> indexer = new SetOnce();

    public TransformTask(long id, String type, String action, TaskId parentTask, Client client, TransformTaskParams transform, TransformState state, SchedulerEngine schedulerEngine, TransformAuditor auditor, ThreadPool threadPool, Map<String, String> headers) {
        super(id, type, action, "data_frame_" + transform.getId(), parentTask, headers);
        this.parentTaskClient = new ParentTaskAssigningClient(client, parentTask);
        this.transform = transform;
        this.schedulerEngine = schedulerEngine;
        this.threadPool = threadPool;
        this.auditor = auditor;
        IndexerState initialState = IndexerState.STOPPED;
        TransformTaskState initialTaskState = TransformTaskState.STOPPED;
        String initialReason = null;
        long initialCheckpoint = 0L;
        TransformIndexerPosition initialPosition = null;
        if (state != null) {
            initialTaskState = state.getTaskState();
            initialReason = state.getReason();
            IndexerState existingState = state.getIndexerState();
            initialState = existingState.equals((Object)IndexerState.INDEXING) ? IndexerState.STARTED : (existingState.equals((Object)IndexerState.ABORTING) || existingState.equals((Object)IndexerState.STOPPING) ? IndexerState.STOPPED : existingState);
            initialPosition = state.getPosition();
            initialCheckpoint = state.getCheckpoint();
        }
        this.initialIndexerState = initialState;
        this.initialPosition = initialPosition;
        this.context = new TransformContext(initialTaskState, initialReason, initialCheckpoint, this);
    }

    public ParentTaskAssigningClient getParentTaskClient() {
        return this.parentTaskClient;
    }

    public String getTransformId() {
        return this.transform.getId();
    }

    public Task.Status getStatus() {
        return this.getState();
    }

    private ClientTransformIndexer getIndexer() {
        return (ClientTransformIndexer)((Object)this.indexer.get());
    }

    public TransformState getState() {
        if (this.getIndexer() == null) {
            return new TransformState(this.context.getTaskState(), this.initialIndexerState, this.initialPosition, this.context.getCheckpoint(), this.context.getStateReason(), null, null, false);
        }
        return new TransformState(this.context.getTaskState(), ((ClientTransformIndexer)((Object)this.indexer.get())).getState(), (TransformIndexerPosition)((ClientTransformIndexer)((Object)this.indexer.get())).getPosition(), this.context.getCheckpoint(), this.context.getStateReason(), this.getIndexer().getProgress(), null, this.context.shouldStopAtCheckpoint());
    }

    public TransformIndexerStats getStats() {
        if (this.getIndexer() == null) {
            return new TransformIndexerStats();
        }
        return (TransformIndexerStats)this.getIndexer().getStats();
    }

    public void getCheckpointingInfo(TransformCheckpointService transformsCheckpointService, ActionListener<TransformCheckpointingInfo> listener) {
        ActionListener checkPointInfoListener = ActionListener.wrap(infoBuilder -> {
            if (this.context.getChangesLastDetectedAt() != null) {
                infoBuilder.setChangesLastDetectedAt(this.context.getChangesLastDetectedAt());
            }
            listener.onResponse((Object)infoBuilder.build());
        }, arg_0 -> listener.onFailure(arg_0));
        ClientTransformIndexer indexer = this.getIndexer();
        if (indexer == null) {
            transformsCheckpointService.getCheckpointingInfo((Client)this.parentTaskClient, this.transform.getId(), this.context.getCheckpoint(), this.initialPosition, null, (ActionListener<TransformCheckpointingInfo.TransformCheckpointingInfoBuilder>)checkPointInfoListener);
            return;
        }
        indexer.getCheckpointProvider().getCheckpointingInfo(indexer.getLastCheckpoint(), indexer.getNextCheckpoint(), (TransformIndexerPosition)indexer.getPosition(), indexer.getProgress(), (ActionListener<TransformCheckpointingInfo.TransformCheckpointingInfoBuilder>)checkPointInfoListener);
    }

    synchronized void start(Long startingCheckpoint, ActionListener<StartTransformAction.Response> listener) {
        logger.debug("[{}] start called with state [{}].", (Object)this.getTransformId(), (Object)this.getState());
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            listener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Unable to start transform [{0}] as it is in a failed state with failure: [{1}]. Use force stop and then restart the transform once error is resolved.", (Object[])new Object[]{this.getTransformId(), this.context.getStateReason()}), RestStatus.CONFLICT, new Object[0]));
            return;
        }
        if (this.getIndexer() == null) {
            String msg = this.context.getTaskState() == TransformTaskState.FAILED ? "It failed during the initialization process; force stop to allow reinitialization." : "Try again later.";
            listener.onFailure((Exception)new ElasticsearchStatusException("Task for transform [{}] not fully initialized. {}", RestStatus.CONFLICT, new Object[]{this.getTransformId(), msg}));
            return;
        }
        IndexerState newState = this.getIndexer().start();
        if (Arrays.stream(RUNNING_STATES).noneMatch(arg_0 -> newState.equals(arg_0))) {
            listener.onFailure((Exception)new ElasticsearchException("Cannot start task for transform [{}], because state was [{}]", new Object[]{this.transform.getId(), newState}));
            return;
        }
        this.context.resetTaskState();
        if (startingCheckpoint != null) {
            this.context.setCheckpoint(startingCheckpoint);
        }
        TransformState state = new TransformState(TransformTaskState.STARTED, IndexerState.STOPPED, (TransformIndexerPosition)this.getIndexer().getPosition(), this.context.getCheckpoint(), null, this.getIndexer().getProgress(), null, this.context.shouldStopAtCheckpoint());
        logger.info("[{}] updating state for transform to [{}].", (Object)this.transform.getId(), (Object)state.toString());
        this.persistStateToClusterState(state, ActionListener.wrap(task -> {
            this.auditor.info(this.transform.getId(), "Updated transform state to [" + state.getTaskState() + "].");
            long now = System.currentTimeMillis();
            this.triggered(new SchedulerEngine.Event(this.schedulerJobName(), now, now));
            this.registerWithSchedulerJob();
            listener.onResponse((Object)new StartTransformAction.Response(true));
        }, exc -> {
            this.auditor.warning(this.transform.getId(), "Failed to persist to cluster state while marking task as started. Failure: " + exc.getMessage());
            logger.error((Message)new ParameterizedMessage("[{}] failed updating state to [{}].", (Object)this.getTransformId(), (Object)state), (Throwable)exc);
            this.getIndexer().stop();
            listener.onFailure((Exception)new ElasticsearchException("Error while updating state for transform [" + this.transform.getId() + "] to [" + state.getIndexerState() + "].", (Throwable)exc, new Object[0]));
        }));
    }

    void setShouldStopAtCheckpoint(boolean shouldStopAtCheckpoint) {
        this.context.setShouldStopAtCheckpoint(shouldStopAtCheckpoint);
    }

    public synchronized void setShouldStopAtCheckpoint(boolean shouldStopAtCheckpoint, ActionListener<Void> shouldStopAtCheckpointListener) {
        logger.debug("[{}] attempted to set task to stop at checkpoint [{}] with state [{}]", (Object)this.getTransformId(), (Object)shouldStopAtCheckpoint, (Object)this.getState());
        if (this.context.getTaskState() != TransformTaskState.STARTED || this.getIndexer() == null) {
            shouldStopAtCheckpointListener.onResponse(null);
            return;
        }
        this.getIndexer().persistShouldStopAtCheckpoint(shouldStopAtCheckpoint, shouldStopAtCheckpointListener);
    }

    public synchronized void stop(boolean force, boolean shouldStopAtCheckpoint) {
        IndexerState state;
        logger.debug("[{}] stop called with force [{}], shouldStopAtCheckpoint [{}], state [{}], indexerstate[{}]", (Object)this.getTransformId(), (Object)force, (Object)shouldStopAtCheckpoint, (Object)this.getState(), this.getIndexer() != null ? this.getIndexer().getState() : null);
        if (this.context.getTaskState() == TransformTaskState.FAILED && !force) {
            throw new ElasticsearchStatusException(TransformMessages.getMessage((String)"Unable to stop transform [{0}] as it is in a failed state with reason [{1}]. Use force stop to stop the transform.", (Object[])new Object[]{this.getTransformId(), this.context.getStateReason()}), RestStatus.CONFLICT, new Object[0]);
        }
        boolean wasFailed = this.context.setTaskState(TransformTaskState.FAILED, TransformTaskState.STARTED);
        this.context.resetReasonAndFailureCounter();
        if (this.getIndexer() == null) {
            this.shutdown();
            return;
        }
        if (wasFailed) {
            this.getIndexer().onStop();
            this.getIndexer().doSaveState(IndexerState.STOPPED, (TransformIndexerPosition)this.getIndexer().getPosition(), () -> {});
            return;
        }
        if (this.getIndexer().getState() == IndexerState.STOPPED || this.getIndexer().getState() == IndexerState.STOPPING) {
            return;
        }
        if ((!shouldStopAtCheckpoint || this.getIndexer().getState() == IndexerState.STARTED && this.getIndexer().initialRun()) && (state = this.getIndexer().stop()) == IndexerState.STOPPED) {
            this.getIndexer().onStop();
            this.getIndexer().doSaveState(state, (TransformIndexerPosition)this.getIndexer().getPosition(), () -> {});
        }
    }

    public synchronized void applyNewSettings(SettingsConfig newSettings) {
        this.getIndexer().applyNewSettings(newSettings);
    }

    protected void init(PersistentTasksService persistentTasksService, TaskManager taskManager, String persistentTaskId, long allocationId) {
        super.init(persistentTasksService, taskManager, persistentTaskId, allocationId);
    }

    public synchronized void triggered(SchedulerEngine.Event event) {
        if (!event.getJobName().equals(this.schedulerJobName())) {
            return;
        }
        if (this.getIndexer() == null) {
            logger.warn("[{}] transform task triggered with an unintialized indexer.", (Object)this.getTransformId());
            return;
        }
        if (this.context.getTaskState() == TransformTaskState.FAILED || this.context.getTaskState() == TransformTaskState.STOPPED) {
            logger.debug("[{}] schedule was triggered for transform but task is [{}]. Ignoring trigger.", (Object)this.getTransformId(), (Object)this.context.getTaskState());
            return;
        }
        IndexerState indexerState = this.getIndexer().getState();
        if (IndexerState.INDEXING.equals((Object)indexerState) || IndexerState.STOPPING.equals((Object)indexerState) || IndexerState.STOPPED.equals((Object)indexerState)) {
            logger.debug("[{}] indexer for transform has state [{}]. Ignoring trigger.", (Object)this.getTransformId(), (Object)indexerState);
            return;
        }
        logger.debug("[{}] transform indexer schedule has triggered, state: [{}].", (Object)event.getJobName(), (Object)indexerState);
        if (this.context.getCheckpoint() == 0L) {
            logger.debug("[{}] trigger initial run.", (Object)this.getTransformId());
            this.getIndexer().maybeTriggerAsyncJob(System.currentTimeMillis());
        } else if (this.getIndexer().isContinuous()) {
            this.getIndexer().maybeTriggerAsyncJob(System.currentTimeMillis());
        }
    }

    public boolean shouldCancelChildrenOnCancellation() {
        return false;
    }

    @Override
    public synchronized void shutdown() {
        logger.debug("[{}] shutdown of transform requested", (Object)this.transform.getId());
        this.deregisterSchedulerJob();
        this.markAsCompleted();
    }

    void persistStateToClusterState(TransformState state, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.updatePersistentTaskState((PersistentTaskState)state, ActionListener.wrap(success -> {
            logger.debug("[{}] successfully updated state for transform to [{}].", (Object)this.transform.getId(), (Object)state.toString());
            listener.onResponse(success);
        }, failure -> {
            logger.error((Message)new ParameterizedMessage("[{}] failed to update cluster state for transform.", (Object)this.transform.getId()), (Throwable)failure);
            listener.onFailure(failure);
        }));
    }

    @Override
    public synchronized void fail(String reason, ActionListener<Void> listener) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.warn("[{}] is already failed but encountered new failure; reason [{}].", (Object)this.getTransformId(), (Object)reason);
            listener.onResponse(null);
            return;
        }
        if (this.getIndexer() != null && this.getIndexer().getState() == IndexerState.STOPPING) {
            logger.info("[{}] attempt to fail transform with reason [{}] while it was stopping.", (Object)this.getTransformId(), (Object)reason);
            listener.onResponse(null);
            return;
        }
        if (this.getIndexer() != null && this.getIndexer().getState() == IndexerState.STOPPED) {
            logger.info("[{}] encountered a failure but indexer is STOPPED; reason [{}].", (Object)this.getTransformId(), (Object)reason);
            listener.onResponse(null);
            return;
        }
        logger.error("[{}] transform has failed; experienced: [{}].", (Object)this.transform.getId(), (Object)reason);
        this.auditor.error(this.transform.getId(), reason);
        this.deregisterSchedulerJob();
        this.context.setShouldStopAtCheckpoint(false);
        this.context.setTaskStateToFailed(reason);
        TransformState newState = this.getState();
        this.persistStateToClusterState(newState, ActionListener.wrap(r -> listener.onResponse(null), e -> {
            String msg = "Failed to persist to cluster state while marking task as failed with reason [" + reason + "].";
            this.auditor.warning(this.transform.getId(), msg + " Failure: " + e.getMessage());
            logger.error((Message)new ParameterizedMessage("[{}] {}", (Object)this.getTransformId(), (Object)msg), (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public synchronized void onCancelled() {
        logger.info("[{}] received cancellation request for transform, state: [{}].", (Object)this.getTransformId(), (Object)this.context.getTaskState());
        if (this.getIndexer() != null && this.getIndexer().abort()) {
            this.shutdown();
        }
    }

    TransformTask setNumFailureRetries(int numFailureRetries) {
        this.context.setNumFailureRetries(numFailureRetries);
        return this;
    }

    private void registerWithSchedulerJob() {
        this.schedulerEngine.register((SchedulerEngine.Listener)this);
        SchedulerEngine.Job schedulerJob = new SchedulerEngine.Job(this.schedulerJobName(), this.next());
        this.schedulerEngine.add(schedulerJob);
    }

    private void deregisterSchedulerJob() {
        this.schedulerEngine.remove(this.schedulerJobName());
        this.schedulerEngine.unregister((SchedulerEngine.Listener)this);
    }

    private String schedulerJobName() {
        return "data_frame/transforms/schedule_" + this.getTransformId();
    }

    private SchedulerEngine.Schedule next() {
        return (startTime, now) -> {
            TimeValue frequency = this.transform.getFrequency();
            return now + (frequency == null ? Transform.DEFAULT_TRANSFORM_FREQUENCY.getMillis() : frequency.getMillis());
        };
    }

    synchronized void initializeIndexer(ClientTransformIndexerBuilder indexerBuilder) {
        this.indexer.set((Object)indexerBuilder.build(this.getThreadPool(), "generic", this.context));
    }

    ThreadPool getThreadPool() {
        return this.threadPool;
    }

    TransformTaskState getTaskState() {
        return this.context.getTaskState();
    }
}

