/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;

class TransformContext {
    private final AtomicReference<TransformTaskState> taskState;
    private final AtomicReference<String> stateReason;
    private final Listener taskListener;
    private volatile int numFailureRetries = 10;
    private final AtomicInteger failureCount;
    private volatile Instant changesLastDetectedAt;
    private volatile boolean shouldStopAtCheckpoint;
    private final AtomicLong currentCheckpoint;

    TransformContext(TransformTaskState taskState, String stateReason, long currentCheckpoint, Listener taskListener) {
        this.taskState = new AtomicReference<TransformTaskState>(taskState);
        this.stateReason = new AtomicReference<String>(stateReason);
        this.currentCheckpoint = new AtomicLong(currentCheckpoint);
        this.taskListener = taskListener;
        this.failureCount = new AtomicInteger(0);
        this.shouldStopAtCheckpoint = this.shouldStopAtCheckpoint;
    }

    TransformTaskState getTaskState() {
        return this.taskState.get();
    }

    void setTaskState(TransformTaskState newState) {
        this.taskState.set(newState);
    }

    boolean setTaskState(TransformTaskState oldState, TransformTaskState newState) {
        return this.taskState.compareAndSet(oldState, newState);
    }

    void resetTaskState() {
        this.taskState.set(TransformTaskState.STARTED);
        this.stateReason.set(null);
    }

    void setTaskStateToFailed(String reason) {
        this.taskState.set(TransformTaskState.FAILED);
        this.stateReason.set(reason);
    }

    void resetReasonAndFailureCounter() {
        this.stateReason.set(null);
        this.failureCount.set(0);
    }

    String getStateReason() {
        return this.stateReason.get();
    }

    void setCheckpoint(long newValue) {
        this.currentCheckpoint.set(newValue);
    }

    long getCheckpoint() {
        return this.currentCheckpoint.get();
    }

    long getAndIncrementCheckpoint() {
        return this.currentCheckpoint.getAndIncrement();
    }

    void setNumFailureRetries(int numFailureRetries) {
        this.numFailureRetries = numFailureRetries;
    }

    int getNumFailureRetries() {
        return this.numFailureRetries;
    }

    int getAndIncrementFailureCount() {
        return this.failureCount.getAndIncrement();
    }

    void setChangesLastDetectedAt(Instant time) {
        this.changesLastDetectedAt = time;
    }

    Instant getChangesLastDetectedAt() {
        return this.changesLastDetectedAt;
    }

    public boolean shouldStopAtCheckpoint() {
        return this.shouldStopAtCheckpoint;
    }

    public void setShouldStopAtCheckpoint(boolean shouldStopAtCheckpoint) {
        this.shouldStopAtCheckpoint = shouldStopAtCheckpoint;
    }

    void shutdown() {
        this.taskListener.shutdown();
    }

    void markAsFailed(String failureMessage) {
        this.taskListener.fail(failureMessage, (ActionListener<Void>)ActionListener.wrap(r -> this.failureCount.set(0), e -> {}));
    }

    public static interface Listener {
        public void shutdown();

        public void fail(String var1, ActionListener<Void> var2);
    }
}

