/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.rest.action.compat;

import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.DeleteTransformAction;
import org.elasticsearch.xpack.core.transform.action.compat.DeleteTransformActionDeprecated;

public class RestDeleteTransformActionDeprecated
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestDeleteTransformActionDeprecated.class));

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return Collections.singletonList(new RestHandler.DeprecatedRoute(RestRequest.Method.DELETE, "/_data_frame/transforms/{id}/", "[_data_frame/transforms/] is deprecated, use [_transform/] in the future."));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        if (restRequest.hasContent()) {
            throw new IllegalArgumentException("delete transform requests can not have a request body");
        }
        String id = restRequest.param(TransformField.ID.getPreferredName());
        boolean force = restRequest.paramAsBoolean(TransformField.FORCE.getPreferredName(), false);
        DeleteTransformAction.Request request = new DeleteTransformAction.Request(id, force);
        return channel -> client.execute((ActionType)DeleteTransformActionDeprecated.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "data_frame_delete_transform_action";
    }
}

