/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.io.IOException;
import java.time.Clock;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskParams;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.utils.SourceDestValidations;

public class TransportStartTransformAction
extends TransportMasterNodeAction<StartTransformAction.Request, StartTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStartTransformAction.class);
    private final XPackLicenseState licenseState;
    private final TransformConfigManager transformConfigManager;
    private final PersistentTasksService persistentTasksService;
    private final Client client;
    private final TransformAuditor auditor;
    private final SourceDestValidator sourceDestValidator;
    private final IngestService ingestService;

    @Inject
    public TransportStartTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, XPackLicenseState licenseState, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, PersistentTasksService persistentTasksService, Client client, Settings settings, IngestService ingestService) {
        this("cluster:admin/transform/start", transportService, actionFilters, clusterService, licenseState, threadPool, indexNameExpressionResolver, transformServices, persistentTasksService, client, settings, ingestService);
    }

    protected TransportStartTransformAction(String name, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, XPackLicenseState licenseState, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, PersistentTasksService persistentTasksService, Client client, Settings settings, IngestService ingestService) {
        super(name, transportService, clusterService, threadPool, actionFilters, StartTransformAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.transformConfigManager = transformServices.getConfigManager();
        this.persistentTasksService = persistentTasksService;
        this.client = client;
        this.auditor = transformServices.getAuditor();
        this.sourceDestValidator = new SourceDestValidator(indexNameExpressionResolver, transportService.getRemoteClusterService(), DiscoveryNode.isRemoteClusterClient((Settings)settings) ? new RemoteClusterLicenseChecker(client, XPackLicenseState::isTransformAllowedForOperationMode) : null, clusterService.getNodeName(), License.OperationMode.BASIC.description());
        this.ingestService = ingestService;
    }

    protected String executor() {
        return "same";
    }

    protected StartTransformAction.Response read(StreamInput in) throws IOException {
        return new StartTransformAction.Response(in);
    }

    protected void masterOperation(StartTransformAction.Request request, ClusterState state, ActionListener<StartTransformAction.Response> listener) throws Exception {
        if (!this.licenseState.checkFeature(XPackLicenseState.Feature.TRANSFORM)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"transform"));
            return;
        }
        AtomicReference transformTaskHolder = new AtomicReference();
        AtomicReference transformConfigHolder = new AtomicReference();
        ActionListener newPersistentTaskActionListener = ActionListener.wrap(task -> {
            TransformTaskParams transformTask = (TransformTaskParams)transformTaskHolder.get();
            assert (transformTask != null);
            this.waitForTransformTaskStarted(task.getId(), transformTask, request.timeout(), (ActionListener<Boolean>)ActionListener.wrap(taskStarted -> listener.onResponse((Object)new StartTransformAction.Response(true)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener createOrGetIndexListener = ActionListener.wrap(unused -> {
            TransformTaskParams transformTask = (TransformTaskParams)transformTaskHolder.get();
            assert (transformTask != null);
            PersistentTasksCustomMetadata.PersistentTask<TransformTaskParams> existingTask = TransportStartTransformAction.getExistingTask(transformTask.getId(), state);
            if (existingTask == null) {
                this.persistentTasksService.sendStartRequest(transformTask.getId(), "data_frame/transforms", (PersistentTaskParams)transformTask, newPersistentTaskActionListener);
            } else {
                TransformState transformState = (TransformState)existingTask.getState();
                if (transformState.getTaskState() == TransformTaskState.FAILED) {
                    listener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Unable to start transform [{0}] as it is in a failed state with failure: [{1}]. Use force stop and then restart the transform once error is resolved.", (Object[])new Object[]{request.getId(), transformState.getReason()}), RestStatus.CONFLICT, new Object[0]));
                } else {
                    listener.onFailure((Exception)new ElasticsearchStatusException("Cannot start transform [{}] as it is already started.", RestStatus.CONFLICT, new Object[]{request.getId()}));
                }
            }
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener validationListener = ActionListener.wrap(validationResponse -> {
            String destinationIndex = ((TransformConfig)transformConfigHolder.get()).getDestination().getIndex();
            String[] dest = this.indexNameExpressionResolver.concreteIndexNames(state, IndicesOptions.lenientExpandOpen(), new String[]{destinationIndex});
            if (dest.length == 0) {
                this.createDestinationIndex((TransformConfig)transformConfigHolder.get(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                    this.auditor.info(request.getId(), "Created destination index [" + destinationIndex + "] with deduced mappings.");
                    createOrGetIndexListener.onResponse(r);
                }, arg_0 -> ((ActionListener)createOrGetIndexListener).onFailure(arg_0)));
            } else {
                this.auditor.info(request.getId(), "Using existing destination index [" + destinationIndex + "].");
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"transform", (ActionRequest)((IndicesStatsRequest)this.client.admin().indices().prepareStats(dest).clear().setDocs(true).request()), (ActionListener)ActionListener.wrap(r -> {
                    long docTotal = r.getTotal().docs.getCount();
                    if (docTotal > 0L) {
                        this.auditor.warning(request.getId(), "Non-empty destination index [" + destinationIndex + "]. Contains [" + docTotal + "] total documents.");
                    }
                    createOrGetIndexListener.onResponse((Object)true);
                }, e -> {
                    String msg = "Unable to determine destination index stats, error: " + e.getMessage();
                    logger.warn(msg, (Throwable)e);
                    this.auditor.warning(request.getId(), msg);
                    createOrGetIndexListener.onResponse((Object)true);
                }), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).stats(arg_0, arg_1));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getTransformListener = ActionListener.wrap(config -> {
            if (!config.isValid()) {
                listener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Transform configuration is invalid [{0}]", (Object[])new Object[]{request.getId()}), RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            transformTaskHolder.set(TransportStartTransformAction.createTransform(config.getId(), config.getVersion(), config.getFrequency(), config.getSource().requiresRemoteCluster()));
            transformConfigHolder.set(config);
            if (config.getDestination().getPipeline() != null && this.ingestService.getPipeline(config.getDestination().getPipeline()) == null) {
                listener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Pipeline with id [{0}] could not be found", (Object[])new Object[]{config.getDestination().getPipeline()}), RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            this.sourceDestValidator.validate(this.clusterService.state(), config.getSource().getIndex(), config.getDestination().getIndex(), SourceDestValidations.ALL_VALIDATIONS, validationListener);
        }, arg_0 -> listener.onFailure(arg_0));
        this.transformConfigManager.getTransformConfiguration(request.getId(), (ActionListener<TransformConfig>)getTransformListener);
    }

    private void createDestinationIndex(TransformConfig config, ActionListener<Boolean> listener) {
        Function function = FunctionFactory.create(config);
        ActionListener deduceMappingsListener = ActionListener.wrap(mappings -> {
            TransformDestIndexSettings generateddestIndexSettings = TransformIndex.createTransformDestIndexSettings(mappings, config.getId(), Clock.systemUTC());
            TransformIndex.createDestinationIndex(this.client, config, generateddestIndexSettings, listener);
        }, deduceTargetMappingsException -> listener.onFailure((Exception)new RuntimeException("Failed to deduce dest mappings", (Throwable)deduceTargetMappingsException)));
        function.deduceMappings(this.client, config.getSource(), (ActionListener<Map<String, String>>)deduceMappingsListener);
    }

    protected ClusterBlockException checkBlock(StartTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private static TransformTaskParams createTransform(String transformId, Version transformVersion, TimeValue frequency, Boolean requiresRemoteCluster) {
        return new TransformTaskParams(transformId, transformVersion, frequency, requiresRemoteCluster.booleanValue());
    }

    private static PersistentTasksCustomMetadata.PersistentTask<TransformTaskParams> getExistingTask(String id, ClusterState state) {
        PersistentTasksCustomMetadata pTasksMeta = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        if (pTasksMeta == null) {
            return null;
        }
        Collection existingTask = pTasksMeta.findTasks("data_frame/transforms", t -> t.getId().equals(id));
        if (existingTask.isEmpty()) {
            return null;
        }
        assert (existingTask.size() == 1);
        PersistentTasksCustomMetadata.PersistentTask pTask = (PersistentTasksCustomMetadata.PersistentTask)existingTask.iterator().next();
        if (pTask.getParams() instanceof TransformTaskParams) {
            return pTask;
        }
        throw new ElasticsearchStatusException("Found transform persistent task [" + id + "] with incorrect params", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }

    private void cancelTransformTask(String taskId, final String transformId, final Exception exception, final Consumer<Exception> onFailure) {
        this.persistentTasksService.sendRemoveRequest(taskId, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                onFailure.accept(exception);
            }

            public void onFailure(Exception e) {
                logger.error("[" + transformId + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                onFailure.accept(exception);
            }
        });
    }

    private void waitForTransformTaskStarted(final String taskId, final TransformTaskParams params, TimeValue timeout, final ActionListener<Boolean> listener) {
        final TransformPredicate predicate = new TransformPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, timeout, (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<TransformTaskParams>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<TransformTaskParams> persistentTask) {
                if (predicate.exception != null) {
                    TransportStartTransformAction.this.cancelTransformTask(taskId, params.getId(), predicate.exception, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                } else {
                    listener.onResponse((Object)true);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchException("Starting transform [" + params.getId() + "] timed out after [" + timeout + "]", new Object[0]));
            }
        });
    }

    private class TransformPredicate
    implements Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> {
        private volatile Exception exception;

        private TransformPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
            if (persistentTask == null) {
                return false;
            }
            PersistentTasksCustomMetadata.Assignment assignment = persistentTask.getAssignment();
            if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetadata.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                this.exception = new ElasticsearchStatusException("Could not start transform, allocation explanation [" + assignment.getExplanation() + "]", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
                return true;
            }
            return assignment != null && assignment.isAssigned() && this.isNotStopped(persistentTask);
        }

        private boolean isNotStopped(PersistentTasksCustomMetadata.PersistentTask<?> task) {
            TransformState state = (TransformState)task.getState();
            return state != null && !state.getTaskState().equals((Object)TransformTaskState.STOPPED);
        }
    }
}

