/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.constantkeyword.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class ConstantKeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "constant_keyword";

    ConstantKeywordFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType) {
        super(simpleName, fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    protected ConstantKeywordFieldMapper clone() {
        return (ConstantKeywordFieldMapper)super.clone();
    }

    public ConstantKeywordFieldType fieldType() {
        return (ConstantKeywordFieldType)super.fieldType();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        String value;
        if (context.externalValueSet()) {
            value = context.externalValue().toString();
        } else {
            XContentParser parser = context.parser();
            value = parser.textOrNull();
        }
        if (value == null) {
            throw new IllegalArgumentException("[constant_keyword] field [" + this.name() + "] doesn't accept [null] values");
        }
        if (this.fieldType().value == null) {
            ConstantKeywordFieldType newFieldType = new ConstantKeywordFieldType(this.fieldType().name(), value, this.fieldType().meta());
            ConstantKeywordFieldMapper update = new ConstantKeywordFieldMapper(this.simpleName(), this.fieldType, (MappedFieldType)newFieldType);
            context.addDynamicMapper((Mapper)update);
        } else if (!Objects.equals(this.fieldType().value, value)) {
            throw new IllegalArgumentException("[constant_keyword] field [" + this.name() + "] only accepts values that are equal to the value defined in the mappings [" + this.fieldType().value() + "], but got [" + value + "]");
        }
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        ConstantKeywordFieldType newConstantKeywordFT = (ConstantKeywordFieldType)other.fieldType();
        if (this.fieldType().value != null) {
            if (newConstantKeywordFT.value == null) {
                conflicts.add("mapper [" + this.name() + "] cannot unset [value]");
            } else if (!Objects.equals(this.fieldType().value, newConstantKeywordFT.value)) {
                conflicts.add("mapper [" + this.name() + "] has different [value] from the value that is configured in mappings: [" + this.fieldType().value + "] vs. [" + newConstantKeywordFT.value + "]");
            }
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType().value() != null) {
            builder.field("value", this.fieldType().value());
        }
    }

    public static final class ConstantKeywordFieldType
    extends ConstantFieldType {
        private final String value;

        public ConstantKeywordFieldType(String name, String value, Map<String, String> meta) {
            super(name, meta);
            this.value = value;
        }

        public ConstantKeywordFieldType(String name, String value) {
            this(name, value, Collections.emptyMap());
        }

        public String value() {
            return this.value;
        }

        public String typeName() {
            return ConstantKeywordFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "keyword";
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            return new ConstantIndexFieldData.Builder(mapperService -> this.value, (ValuesSourceType)CoreValuesSourceType.BYTES);
        }

        protected boolean matches(String pattern, QueryShardContext context) {
            if (this.value == null) {
                return false;
            }
            return Regex.simpleMatch((String)pattern, (String)this.value);
        }

        public Query existsQuery(QueryShardContext context) {
            return this.value != null ? new MatchAllDocsQuery() : new MatchNoDocsQuery();
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            BytesRef valueAsBytesRef = new BytesRef((CharSequence)this.value);
            if (lowerTerm != null && BytesRefs.toBytesRef((Object)lowerTerm).compareTo(valueAsBytesRef) >= (includeLower ? 1 : 0)) {
                return new MatchNoDocsQuery();
            }
            if (upperTerm != null && valueAsBytesRef.compareTo(BytesRefs.toBytesRef((Object)upperTerm)) >= (includeUpper ? 1 : 0)) {
                return new MatchNoDocsQuery();
            }
            return new MatchAllDocsQuery();
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, QueryShardContext context) {
            String prefix;
            int cp;
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            String termAsString = BytesRefs.toString((Object)value);
            int maxEdits = fuzziness.asDistance(termAsString);
            int[] termText = new int[termAsString.codePointCount(0, termAsString.length())];
            int j = 0;
            for (int i = 0; i < termAsString.length(); i += Character.charCount(cp)) {
                termText[j++] = cp = termAsString.codePointAt(i);
            }
            int termLength = termText.length;
            String suffix = UnicodeUtil.newString((int[])termText, (int)(prefixLength = Math.min(prefixLength, termLength)), (int)(termText.length - prefixLength));
            LevenshteinAutomata builder = new LevenshteinAutomata(suffix, transpositions);
            Automaton automaton = builder.toAutomaton(maxEdits, prefix = UnicodeUtil.newString((int[])termText, (int)0, (int)prefixLength));
            CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton);
            if (runAutomaton.run(this.value)) {
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }

        public Query regexpQuery(String value, int flags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (this.value == null) {
                return new MatchNoDocsQuery();
            }
            Automaton automaton = new RegExp(value, flags).toAutomaton(maxDeterminizedStates);
            CharacterRunAutomaton runAutomaton = new CharacterRunAutomaton(automaton);
            if (runAutomaton.run(this.value)) {
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Object value = null;
            if (node.containsKey("value")) {
                value = node.remove("value");
                if (value == null) {
                    throw new MapperParsingException("Property [value] of field [" + name + "] can't be [null].");
                }
                if (!(value instanceof Number) && !(value instanceof CharSequence)) {
                    throw new MapperParsingException("Property [value] of field [" + name + "] must be a number or a string, but got [" + value + "]");
                }
            }
            Builder builder = new Builder(name);
            if (value != null) {
                builder.setValue(value.toString());
            }
            if (node.containsKey("meta")) {
                builder.meta(TypeParsers.parseMeta((String)name, (Object)node.remove("meta")));
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        String value;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public ConstantKeywordFieldMapper build(Mapper.BuilderContext context) {
            return new ConstantKeywordFieldMapper(this.name, this.fieldType, (MappedFieldType)new ConstantKeywordFieldType(this.buildFullName(context), this.value, this.meta));
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }
}

