/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.action.PutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.SnapshotLifecycleStats;

public class TransportPutSnapshotLifecycleAction
extends TransportMasterNodeAction<PutSnapshotLifecycleAction.Request, PutSnapshotLifecycleAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutSnapshotLifecycleAction.class);

    @Inject
    public TransportPutSnapshotLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/put", transportService, clusterService, threadPool, actionFilters, PutSnapshotLifecycleAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected PutSnapshotLifecycleAction.Response read(StreamInput in) throws IOException {
        return new PutSnapshotLifecycleAction.Response(in);
    }

    protected void masterOperation(final PutSnapshotLifecycleAction.Request request, ClusterState state, ActionListener<PutSnapshotLifecycleAction.Response> listener) {
        SnapshotLifecycleService.validateRepositoryExists(request.getLifecycle().getRepository(), state);
        final Map<String, String> filteredHeaders = this.threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        LifecyclePolicy.validatePolicyName((String)request.getLifecycleId());
        this.clusterService.submitStateUpdateTask("put-snapshot-lifecycle-" + request.getLifecycleId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PutSnapshotLifecycleAction.Response>((AckedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) {
                SnapshotLifecycleMetadata lifecycleMetadata;
                SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)currentState.metadata().custom("snapshot_lifecycle");
                String id = request.getLifecycleId();
                if (snapMeta == null) {
                    SnapshotLifecyclePolicyMetadata meta = SnapshotLifecyclePolicyMetadata.builder().setPolicy(request.getLifecycle()).setHeaders(filteredHeaders).setModifiedDate(Instant.now().toEpochMilli()).build();
                    lifecycleMetadata = new SnapshotLifecycleMetadata(Collections.singletonMap(id, meta), OperationMode.RUNNING, new SnapshotLifecycleStats());
                    logger.info("adding new snapshot lifecycle [{}]", (Object)id);
                } else {
                    HashMap<String, SnapshotLifecyclePolicyMetadata> snapLifecycles = new HashMap<String, SnapshotLifecyclePolicyMetadata>(snapMeta.getSnapshotConfigurations());
                    SnapshotLifecyclePolicyMetadata oldLifecycle = (SnapshotLifecyclePolicyMetadata)snapLifecycles.get(id);
                    SnapshotLifecyclePolicyMetadata newLifecycle = SnapshotLifecyclePolicyMetadata.builder((SnapshotLifecyclePolicyMetadata)oldLifecycle).setPolicy(request.getLifecycle()).setHeaders(filteredHeaders).setVersion(oldLifecycle == null ? 1L : oldLifecycle.getVersion() + 1L).setModifiedDate(Instant.now().toEpochMilli()).build();
                    snapLifecycles.put(id, newLifecycle);
                    lifecycleMetadata = new SnapshotLifecycleMetadata(snapLifecycles, snapMeta.getOperationMode(), snapMeta.getStats());
                    if (oldLifecycle == null) {
                        logger.info("adding new snapshot lifecycle [{}]", (Object)id);
                    } else {
                        logger.info("updating existing snapshot lifecycle [{}]", (Object)id);
                    }
                }
                Metadata currentMeta = currentState.metadata();
                return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentMeta).putCustom("snapshot_lifecycle", (Metadata.Custom)lifecycleMetadata)).build();
            }

            protected PutSnapshotLifecycleAction.Response newResponse(boolean acknowledged) {
                return new PutSnapshotLifecycleAction.Response(acknowledged);
            }
        });
    }

    protected ClusterBlockException checkBlock(PutSnapshotLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

