/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.slm.SnapshotLifecycleStats;

public class TransportGetSnapshotLifecycleStatsAction
extends TransportMasterNodeAction<GetSnapshotLifecycleStatsAction.Request, GetSnapshotLifecycleStatsAction.Response> {
    @Inject
    public TransportGetSnapshotLifecycleStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/stats", transportService, clusterService, threadPool, actionFilters, GetSnapshotLifecycleStatsAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetSnapshotLifecycleStatsAction.Response read(StreamInput in) throws IOException {
        return new GetSnapshotLifecycleStatsAction.Response(in);
    }

    protected void masterOperation(GetSnapshotLifecycleStatsAction.Request request, ClusterState state, ActionListener<GetSnapshotLifecycleStatsAction.Response> listener) {
        SnapshotLifecycleMetadata slmMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
        if (slmMeta == null) {
            listener.onResponse((Object)new GetSnapshotLifecycleStatsAction.Response(new SnapshotLifecycleStats()));
        } else {
            listener.onResponse((Object)new GetSnapshotLifecycleStatsAction.Response(slmMeta.getStats()));
        }
    }

    protected ClusterBlockException checkBlock(GetSnapshotLifecycleStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

