/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.slm.action.PutSnapshotLifecycleAction;

public class RestPutSnapshotLifecycleAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_slm/policy/{name}"));
    }

    public String getName() {
        return "slm_put_lifecycle";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String snapLifecycleName = request.param("name");
        try (XContentParser parser = request.contentParser();){
            PutSnapshotLifecycleAction.Request req = PutSnapshotLifecycleAction.Request.parseRequest((String)snapLifecycleName, (XContentParser)parser);
            req.timeout(request.paramAsTime("timeout", req.timeout()));
            req.masterNodeTimeout(request.paramAsTime("master_timeout", req.masterNodeTimeout()));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)PutSnapshotLifecycleAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
            return restChannelConsumer;
        }
    }
}

