/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.history;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.ilm.history.ILMHistoryItem;
import org.elasticsearch.xpack.ilm.history.ILMHistoryTemplateRegistry;

public class ILMHistoryStore
implements Closeable {
    private static final Logger logger = LogManager.getLogger(ILMHistoryStore.class);
    public static final String ILM_HISTORY_INDEX_PREFIX = "ilm-history-2-";
    public static final String ILM_HISTORY_ALIAS = "ilm-history-2";
    private final boolean ilmHistoryEnabled;
    private final BulkProcessor processor;
    private final ThreadPool threadPool;

    public ILMHistoryStore(Settings nodeSettings, final Client client, final ClusterService clusterService, ThreadPool threadPool) {
        this.ilmHistoryEnabled = (Boolean)LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
        this.threadPool = threadPool;
        this.processor = BulkProcessor.builder((arg_0, arg_1) -> ((OriginSettingClient)new OriginSettingClient(client, "index_lifecycle")).bulk(arg_0, arg_1), (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                try {
                    CompletableFuture indexCreated = new CompletableFuture();
                    ILMHistoryStore.ensureHistoryIndex(client, clusterService.state(), (ActionListener<Boolean>)ActionListener.wrap(indexCreated::complete, ex -> {
                        logger.warn("failed to create ILM history store index prior to issuing bulk request", (Throwable)ex);
                        indexCreated.completeExceptionally((Throwable)ex);
                    }));
                    indexCreated.get(2L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    logger.warn((Message)new ParameterizedMessage("unable to index the following ILM history items:\n{}", (Object)request.requests().stream().filter(dwr -> dwr instanceof IndexRequest).map(dwr -> (IndexRequest)dwr).map(IndexRequest::sourceAsMap).map(Object::toString).collect(Collectors.joining("\n"))), (Throwable)e);
                    throw new ElasticsearchException((Throwable)e);
                }
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                long items = request.numberOfActions();
                if (logger.isTraceEnabled()) {
                    logger.trace("indexed [{}] items into ILM history index [{}]", (Object)items, (Object)Arrays.stream(response.getItems()).map(BulkItemResponse::getIndex).distinct().collect(Collectors.joining(",")));
                }
                if (response.hasFailures()) {
                    Map<String, String> failures = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).collect(Collectors.toMap(BulkItemResponse::getId, BulkItemResponse::getFailureMessage));
                    logger.error("failures: [{}]", failures);
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                long items = request.numberOfActions();
                logger.error((Message)new ParameterizedMessage("failed to index {} items into ILM history index", (Object)items), failure);
            }
        }).setBulkActions(100).setBulkSize(new ByteSizeValue(5L, ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds((long)5L)).setConcurrentRequests(1).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3)).build();
    }

    public void putAsync(ILMHistoryItem item) {
        if (!this.ilmHistoryEnabled) {
            logger.trace("not recording ILM history item because [{}] is [false]: [{}]", (Object)LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING.getKey(), (Object)item);
            return;
        }
        logger.trace("queueing ILM history item for indexing [{}]: [{}]", (Object)ILM_HISTORY_ALIAS, (Object)item);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            item.toXContent(builder, ToXContent.EMPTY_PARAMS);
            IndexRequest request = new IndexRequest(ILM_HISTORY_ALIAS).source(builder);
            this.threadPool.executor("generic").execute(() -> {
                try {
                    this.processor.add(request);
                }
                catch (Exception e) {
                    logger.error((Message)new ParameterizedMessage("failed add ILM history item to queue for index [{}]: [{}]", (Object)ILM_HISTORY_ALIAS, (Object)item), (Throwable)e);
                }
            });
        }
        catch (IOException exception) {
            logger.error((Message)new ParameterizedMessage("failed to queue ILM history item in index [{}]: [{}]", (Object)ILM_HISTORY_ALIAS, (Object)item), (Throwable)exception);
        }
    }

    static void ensureHistoryIndex(Client client, ClusterState state, final ActionListener<Boolean> listener) {
        String initialHistoryIndexName = "ilm-history-2-000001";
        IndexAbstraction ilmHistory = (IndexAbstraction)state.metadata().getIndicesLookup().get(ILM_HISTORY_ALIAS);
        IndexAbstraction initialHistoryIndex = (IndexAbstraction)state.metadata().getIndicesLookup().get("ilm-history-2-000001");
        if (ilmHistory == null && initialHistoryIndex == null) {
            logger.debug("creating ILM history index [{}]", (Object)"ilm-history-2-000001");
            byte[] templateBytes = ILMHistoryTemplateRegistry.TEMPLATE_ILM_HISTORY.loadBytes();
            Map templateAsMap = (Map)XContentHelper.convertToMap((BytesReference)new BytesArray(templateBytes, 0, templateBytes.length), (boolean)false, (XContentType)XContentType.JSON).v2();
            client.admin().indices().prepareCreate("ilm-history-2-000001").setSettings((Map)templateAsMap.get("settings")).addMapping("_doc", (Map)templateAsMap.get("mappings")).setWaitForActiveShards(1).addAlias(new Alias(ILM_HISTORY_ALIAS).writeIndex(Boolean.valueOf(true)).isHidden(Boolean.valueOf(true))).execute((ActionListener)new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse response) {
                    listener.onResponse((Object)true);
                }

                public void onFailure(Exception e) {
                    if (e instanceof ResourceAlreadyExistsException) {
                        logger.debug("index [{}] was created after checking for its existence, likely due to a concurrent call", (Object)"ilm-history-2-000001");
                        listener.onResponse((Object)false);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else if (ilmHistory == null) {
            listener.onFailure((Exception)new IllegalStateException("ILM history index [ilm-history-2-000001] already exists but does not have alias [ilm-history-2]"));
        } else if (ilmHistory.getType() == IndexAbstraction.Type.ALIAS) {
            if (ilmHistory.getWriteIndex() != null) {
                listener.onResponse((Object)false);
            } else {
                listener.onFailure((Exception)new IllegalStateException("ILM history alias [ilm-history-2does not have a write index"));
            }
        } else if (ilmHistory.getType() != IndexAbstraction.Type.ALIAS) {
            listener.onFailure((Exception)new IllegalStateException("ILM history alias [ilm-history-2] already exists as " + ilmHistory.getType().getDisplayName()));
        } else {
            logger.error("unexpected IndexOrAlias for [{}]: [{}]", (Object)ILM_HISTORY_ALIAS, (Object)ilmHistory);
            assert (false) : "ilm-history-2 cannot be both an alias and not an alias simultaneously";
        }
    }

    @Override
    public void close() {
        try {
            this.processor.awaitClose(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("failed to shut down ILM history bulk processor after 10 seconds", (Throwable)e);
        }
    }
}

