/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;

public class MoveToErrorStepUpdateTask
extends ClusterStateUpdateTask {
    private final Index index;
    private final String policy;
    private final Step.StepKey currentStepKey;
    private final BiFunction<IndexMetadata, Step.StepKey, Step> stepLookupFunction;
    private final Consumer<ClusterState> stateChangeConsumer;
    private LongSupplier nowSupplier;
    private Exception cause;

    public MoveToErrorStepUpdateTask(Index index, String policy, Step.StepKey currentStepKey, Exception cause, LongSupplier nowSupplier, BiFunction<IndexMetadata, Step.StepKey, Step> stepLookupFunction, Consumer<ClusterState> stateChangeConsumer) {
        this.index = index;
        this.policy = policy;
        this.currentStepKey = currentStepKey;
        this.cause = cause;
        this.nowSupplier = nowSupplier;
        this.stepLookupFunction = stepLookupFunction;
        this.stateChangeConsumer = stateChangeConsumer;
    }

    Index getIndex() {
        return this.index;
    }

    String getPolicy() {
        return this.policy;
    }

    Step.StepKey getCurrentStepKey() {
        return this.currentStepKey;
    }

    Exception getCause() {
        return this.cause;
    }

    public ClusterState execute(ClusterState currentState) throws IOException {
        IndexMetadata idxMeta = currentState.getMetadata().index(this.index);
        if (idxMeta == null) {
            return currentState;
        }
        Settings indexSettings = idxMeta.getSettings();
        LifecycleExecutionState indexILMData = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)idxMeta);
        if (this.policy.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexSettings)) && this.currentStepKey.equals((Object)LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)indexILMData))) {
            return IndexLifecycleTransition.moveClusterStateToErrorStep(this.index, currentState, this.cause, this.nowSupplier, this.stepLookupFunction);
        }
        return currentState;
    }

    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
        if (!newState.equals(oldState)) {
            this.stateChangeConsumer.accept(newState);
        }
    }

    public void onFailure(String source, Exception e) {
        throw new ElasticsearchException("policy [" + this.policy + "] for index [" + this.index.getName() + "] failed trying to move from step [" + this.currentStepKey + "] to the ERROR step.", (Throwable)e, new Object[0]);
    }
}

