/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;
import org.elasticsearch.xpack.watcher.Watcher;

public class WatcherIndexTemplateRegistry
extends IndexTemplateRegistry {
    public static final String WATCHER_TEMPLATE_VERSION_VARIABLE = "xpack.watcher.template.version";
    public static final IndexTemplateConfig TEMPLATE_CONFIG_TRIGGERED_WATCHES = new IndexTemplateConfig(".triggered_watches", "/triggered-watches.json", 11, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY = new IndexTemplateConfig(".watch-history-11", "/watch-history.json", 11, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_10 = new IndexTemplateConfig(".watch-history-10", "/watch-history-10.json", 10, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM = new IndexTemplateConfig(".watch-history-no-ilm-11", "/watch-history-no-ilm.json", 11, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM_10 = new IndexTemplateConfig(".watch-history-no-ilm-10", "/watch-history-no-ilm-10.json", 10, "xpack.watcher.template.version");
    public static final IndexTemplateConfig TEMPLATE_CONFIG_WATCHES = new IndexTemplateConfig(".watches", "/watches.json", 11, "xpack.watcher.template.version");
    public static final LifecyclePolicyConfig POLICY_WATCH_HISTORY = new LifecyclePolicyConfig("watch-history-ilm-policy", "/watch-history-ilm-policy.json");
    private final boolean ilmManagementEnabled;

    public WatcherIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.ilmManagementEnabled = (Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(nodeSettings);
    }

    protected List<IndexTemplateConfig> getLegacyTemplateConfigs() {
        if (this.clusterService.state().nodes().getMinNodeVersion().onOrAfter(Version.V_7_7_0)) {
            return Arrays.asList(this.ilmManagementEnabled ? TEMPLATE_CONFIG_WATCH_HISTORY : TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM, TEMPLATE_CONFIG_TRIGGERED_WATCHES, TEMPLATE_CONFIG_WATCHES);
        }
        return Arrays.asList(this.ilmManagementEnabled ? TEMPLATE_CONFIG_WATCH_HISTORY_10 : TEMPLATE_CONFIG_WATCH_HISTORY_NO_ILM_10, TEMPLATE_CONFIG_TRIGGERED_WATCHES, TEMPLATE_CONFIG_WATCHES);
    }

    protected List<LifecyclePolicyConfig> getPolicyConfigs() {
        if (!((Boolean)Watcher.USE_ILM_INDEX_MANAGEMENT.get(this.settings)).booleanValue()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(POLICY_WATCH_HISTORY);
    }

    protected String getOrigin() {
        return "watcher";
    }

    public static boolean validate(ClusterState state) {
        if (state.nodes().getMinNodeVersion().onOrAfter(Version.V_7_7_0)) {
            return (state.getMetadata().getTemplates().containsKey((Object)".watch-history-11") || state.getMetadata().getTemplates().containsKey((Object)".watch-history-no-ilm-11")) && state.getMetadata().getTemplates().containsKey((Object)".triggered_watches") && state.getMetadata().getTemplates().containsKey((Object)".watches");
        }
        return (state.getMetadata().getTemplates().containsKey((Object)".watch-history-10") || state.getMetadata().getTemplates().containsKey((Object)".watch-history-no-ilm-10")) && state.getMetadata().getTemplates().containsKey((Object)".triggered_watches") && state.getMetadata().getTemplates().containsKey((Object)".watches");
    }
}

