/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;

public final class CurrentExecutions
implements Iterable<ExecutionService.WatchExecution> {
    private static final Logger logger = LogManager.getLogger(CurrentExecutions.class);
    private final ConcurrentMap<String, ExecutionService.WatchExecution> currentExecutions = new ConcurrentHashMap<String, ExecutionService.WatchExecution>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition empty = this.lock.newCondition();
    private SetOnce<Boolean> seal = new SetOnce();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String id, ExecutionService.WatchExecution execution) {
        this.lock.lock();
        try {
            if (this.seal.get() != null) {
                throw Exceptions.illegalState((String)"could not register execution [{}]. current executions are sealed and forbid registrations of additional executions.", (Object[])new Object[]{id});
            }
            boolean bl = this.currentExecutions.putIfAbsent(id, execution) != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(String id) {
        this.lock.lock();
        try {
            this.currentExecutions.remove(id);
            if (this.currentExecutions.isEmpty()) {
                this.empty.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sealAndAwaitEmpty(TimeValue maxStopTimeout, Runnable stoppedListener) {
        assert (stoppedListener != null);
        this.lock.lock();
        try {
            this.seal.set((Object)true);
            while (this.currentExecutions.size() > 0) {
                this.empty.await(maxStopTimeout.millis(), TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            stoppedListener.run();
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<ExecutionService.WatchExecution> iterator() {
        return this.currentExecutions.values().iterator();
    }
}

