/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.idp;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProviderBuilder;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderResolver;
import org.elasticsearch.xpack.idp.saml.sp.ServiceProviderDefaults;
import org.elasticsearch.xpack.idp.saml.sp.WildcardServiceProviderResolver;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.security.x509.X509Credential;

public class SamlIdentityProvider {
    private final Logger logger = LogManager.getLogger();
    private final String entityId;
    private final Map<String, URL> ssoEndpoints;
    private final Map<String, URL> sloEndpoints;
    private final Set<String> allowedNameIdFormats;
    private final ServiceProviderDefaults serviceProviderDefaults;
    private final X509Credential signingCredential;
    private final SamlServiceProviderResolver serviceProviderResolver;
    private final WildcardServiceProviderResolver wildcardServiceResolver;
    private final X509Credential metadataSigningCredential;
    private ContactInfo technicalContact;
    private OrganizationInfo organization;

    SamlIdentityProvider(String entityId, Map<String, URL> ssoEndpoints, Map<String, URL> sloEndpoints, Set<String> allowedNameIdFormats, X509Credential signingCredential, X509Credential metadataSigningCredential, ContactInfo technicalContact, OrganizationInfo organization, ServiceProviderDefaults serviceProviderDefaults, SamlServiceProviderResolver serviceProviderResolver, WildcardServiceProviderResolver wildcardServiceResolver) {
        this.entityId = entityId;
        this.ssoEndpoints = ssoEndpoints;
        this.sloEndpoints = sloEndpoints;
        this.allowedNameIdFormats = allowedNameIdFormats;
        this.signingCredential = signingCredential;
        this.serviceProviderDefaults = serviceProviderDefaults;
        this.metadataSigningCredential = metadataSigningCredential;
        this.technicalContact = technicalContact;
        this.organization = organization;
        this.serviceProviderResolver = serviceProviderResolver;
        this.wildcardServiceResolver = wildcardServiceResolver;
    }

    public static SamlIdentityProviderBuilder builder(SamlServiceProviderResolver serviceResolver, WildcardServiceProviderResolver wildcardResolver) {
        return new SamlIdentityProviderBuilder(serviceResolver, wildcardResolver);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public URL getSingleSignOnEndpoint(String binding) {
        return this.ssoEndpoints.get(binding);
    }

    public URL getSingleLogoutEndpoint(String binding) {
        return this.sloEndpoints.get(binding);
    }

    public Set<String> getAllowedNameIdFormats() {
        return this.allowedNameIdFormats;
    }

    public X509Credential getSigningCredential() {
        return this.signingCredential;
    }

    public X509Credential getMetadataSigningCredential() {
        return this.metadataSigningCredential;
    }

    public OrganizationInfo getOrganization() {
        return this.organization;
    }

    public ContactInfo getTechnicalContact() {
        return this.technicalContact;
    }

    public ServiceProviderDefaults getServiceProviderDefaults() {
        return this.serviceProviderDefaults;
    }

    public void resolveServiceProvider(String spEntityId, @Nullable String acs, boolean allowDisabled, ActionListener<SamlServiceProvider> listener) {
        this.serviceProviderResolver.resolve(spEntityId, (ActionListener<SamlServiceProvider>)ActionListener.wrap(sp -> {
            if (sp == null) {
                this.logger.debug("No explicitly registered service provider exists for entityId [{}]", (Object)spEntityId);
                this.resolveWildcardService(spEntityId, acs, listener);
            } else if (!allowDisabled && !sp.isEnabled()) {
                this.logger.info("Service provider [{}][{}] is not enabled", (Object)spEntityId, (Object)sp.getName());
                listener.onResponse(null);
            } else {
                this.logger.debug("Service provider for [{}] is [{}]", (Object)spEntityId, sp);
                listener.onResponse(sp);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void resolveWildcardService(String entityId, String acs, ActionListener<SamlServiceProvider> listener) {
        if (acs == null) {
            this.logger.debug("No ACS provided for [{}], skipping wildcard matching", (Object)entityId);
            listener.onResponse(null);
        } else {
            try {
                SamlServiceProvider sp = this.wildcardServiceResolver.resolve(entityId, acs);
                this.logger.debug("Wildcard service provider for [{}][{}] is [{}]", (Object)entityId, (Object)acs, (Object)sp);
                listener.onResponse((Object)sp);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlIdentityProvider that = (SamlIdentityProvider)o;
        return Objects.equals(this.entityId, that.entityId) && Objects.equals(this.ssoEndpoints, that.ssoEndpoints) && Objects.equals(this.sloEndpoints, that.sloEndpoints) && Objects.equals(this.allowedNameIdFormats, that.allowedNameIdFormats) && Objects.equals(this.signingCredential, that.signingCredential) && Objects.equals(this.metadataSigningCredential, that.metadataSigningCredential) && Objects.equals(this.technicalContact, that.technicalContact) && Objects.equals(this.organization, that.organization);
    }

    public int hashCode() {
        return Objects.hash(this.entityId);
    }

    public static class ContactInfo {
        static final Map<String, ContactPersonTypeEnumeration> TYPES = Collections.unmodifiableMap(MapBuilder.newMapBuilder(new LinkedHashMap()).put((Object)ContactPersonTypeEnumeration.ADMINISTRATIVE.toString(), (Object)ContactPersonTypeEnumeration.ADMINISTRATIVE).put((Object)ContactPersonTypeEnumeration.BILLING.toString(), (Object)ContactPersonTypeEnumeration.BILLING).put((Object)ContactPersonTypeEnumeration.SUPPORT.toString(), (Object)ContactPersonTypeEnumeration.SUPPORT).put((Object)ContactPersonTypeEnumeration.TECHNICAL.toString(), (Object)ContactPersonTypeEnumeration.TECHNICAL).put((Object)ContactPersonTypeEnumeration.OTHER.toString(), (Object)ContactPersonTypeEnumeration.OTHER).map());
        public final ContactPersonTypeEnumeration type;
        public final String givenName;
        public final String surName;
        public final String email;

        public ContactInfo(ContactPersonTypeEnumeration type, String givenName, String surName, String email) {
            this.type = Objects.requireNonNull(type, "Contact Person Type is required");
            this.givenName = givenName;
            this.surName = surName;
            this.email = Objects.requireNonNull(email, "Contact Person email is required");
        }

        public static ContactPersonTypeEnumeration getType(String name) {
            ContactPersonTypeEnumeration type = TYPES.get(name.toLowerCase(Locale.ROOT));
            if (type == null) {
                throw new IllegalArgumentException("Invalid contact type " + name + " allowed values are " + Strings.collectionToCommaDelimitedString(TYPES.keySet()));
            }
            return type;
        }
    }

    public static class OrganizationInfo {
        public final String organizationName;
        public final String displayName;
        public final String url;

        public OrganizationInfo(String organizationName, String displayName, String url) {
            this.organizationName = organizationName;
            this.displayName = displayName;
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrganizationInfo that = (OrganizationInfo)o;
            return Objects.equals(this.organizationName, that.organizationName) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(this.organizationName, this.displayName, this.url);
        }
    }
}

