/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.token;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class CreateTokenResponse
extends ActionResponse
implements ToXContentObject {
    private String tokenString;
    private TimeValue expiresIn;
    private String scope;
    private String refreshToken;
    private String kerberosAuthenticationResponseToken;

    CreateTokenResponse() {
    }

    public CreateTokenResponse(StreamInput in) throws IOException {
        super(in);
        this.tokenString = in.readString();
        this.expiresIn = in.readTimeValue();
        this.scope = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_6_5_0)) {
            this.refreshToken = in.readOptionalString();
        } else if (in.getVersion().onOrAfter(Version.V_6_2_0)) {
            this.refreshToken = in.readString();
        }
        this.kerberosAuthenticationResponseToken = in.readOptionalString();
    }

    public CreateTokenResponse(String tokenString, TimeValue expiresIn, String scope, String refreshToken, String kerberosAuthenticationResponseToken) {
        this.tokenString = Objects.requireNonNull(tokenString);
        this.expiresIn = Objects.requireNonNull(expiresIn);
        this.scope = scope;
        this.refreshToken = refreshToken;
        this.kerberosAuthenticationResponseToken = kerberosAuthenticationResponseToken;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getScope() {
        return this.scope;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getKerberosAuthenticationResponseToken() {
        return this.kerberosAuthenticationResponseToken;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.tokenString);
        out.writeTimeValue(this.expiresIn);
        out.writeOptionalString(this.scope);
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeOptionalString(this.refreshToken);
        } else if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            if (this.refreshToken == null) {
                out.writeString("");
            } else {
                out.writeString(this.refreshToken);
            }
        }
        out.writeOptionalString(this.kerberosAuthenticationResponseToken);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("access_token", this.tokenString).field("type", "Bearer").field("expires_in", this.expiresIn.seconds());
        if (this.refreshToken != null) {
            builder.field("refresh_token", this.refreshToken);
        }
        if (this.scope != null) {
            builder.field("scope", this.scope);
        }
        if (this.kerberosAuthenticationResponseToken != null) {
            builder.field("kerberos_authentication_response_token", this.kerberosAuthenticationResponseToken);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CreateTokenResponse that = (CreateTokenResponse)((Object)o);
        return Objects.equals(this.tokenString, that.tokenString) && Objects.equals(this.expiresIn, that.expiresIn) && Objects.equals(this.scope, that.scope) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.kerberosAuthenticationResponseToken, that.kerberosAuthenticationResponseToken);
    }

    public int hashCode() {
        return Objects.hash(this.tokenString, this.expiresIn, this.scope, this.refreshToken, this.kerberosAuthenticationResponseToken);
    }
}

