/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.saml;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;

public final class SamlCompleteLogoutRequest
extends ActionRequest {
    @Nullable
    private String queryString;
    @Nullable
    private String content;
    private List<String> validRequestIds;
    private String realm;

    public SamlCompleteLogoutRequest(StreamInput in) throws IOException {
        super(in);
    }

    public SamlCompleteLogoutRequest() {
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Strings.hasText((String)this.realm)) {
            validationException = ValidateActions.addValidationError((String)"realm may not be empty", validationException);
        }
        if (!Strings.hasText((String)this.queryString) && !Strings.hasText((String)this.content)) {
            validationException = ValidateActions.addValidationError((String)"queryString and content may not both be empty", (ActionRequestValidationException)validationException);
        }
        if (Strings.hasText((String)this.queryString) && Strings.hasText((String)this.content)) {
            validationException = ValidateActions.addValidationError((String)"queryString and content may not both present", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<String> getValidRequestIds() {
        return this.validRequestIds;
    }

    public void setValidRequestIds(List<String> validRequestIds) {
        this.validRequestIds = validRequestIds;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean isHttpRedirect() {
        return this.queryString != null;
    }

    public String getPayload() {
        return this.isHttpRedirect() ? this.queryString : this.content;
    }
}

