/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.saml;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public final class SamlAuthenticateResponse
extends ActionResponse {
    private String principal;
    private String tokenString;
    private String refreshToken;
    private String realm;
    private TimeValue expiresIn;

    public SamlAuthenticateResponse(StreamInput in) throws IOException {
        super(in);
        this.principal = in.readString();
        if (in.getVersion().onOrAfter(Version.V_7_7_0)) {
            this.realm = in.readString();
        }
        this.tokenString = in.readString();
        this.refreshToken = in.readString();
        this.expiresIn = in.readTimeValue();
    }

    public SamlAuthenticateResponse(String principal, String realm, String tokenString, String refreshToken, TimeValue expiresIn) {
        this.principal = principal;
        this.realm = realm;
        this.tokenString = tokenString;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.principal);
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeString(this.realm);
        }
        out.writeString(this.tokenString);
        out.writeString(this.refreshToken);
        out.writeTimeValue(this.expiresIn);
    }
}

