/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class OpenIdConnectAuthenticateResponse
extends ActionResponse {
    private String principal;
    private String accessTokenString;
    private String refreshTokenString;
    private TimeValue expiresIn;

    public OpenIdConnectAuthenticateResponse(String principal, String accessTokenString, String refreshTokenString, TimeValue expiresIn) {
        this.principal = principal;
        this.accessTokenString = accessTokenString;
        this.refreshTokenString = refreshTokenString;
        this.expiresIn = expiresIn;
    }

    public OpenIdConnectAuthenticateResponse(StreamInput in) throws IOException {
        super(in);
        this.principal = in.readString();
        this.accessTokenString = in.readString();
        this.refreshTokenString = in.readString();
        this.expiresIn = in.readTimeValue();
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getAccessTokenString() {
        return this.accessTokenString;
    }

    public String getRefreshTokenString() {
        return this.refreshTokenString;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.principal);
        out.writeString(this.accessTokenString);
        out.writeString(this.refreshTokenString);
        out.writeTimeValue(this.expiresIn);
    }
}

