/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;

public final class GrantApiKeyRequest
extends ActionRequest {
    public static final String PASSWORD_GRANT_TYPE = "password";
    public static final String ACCESS_TOKEN_GRANT_TYPE = "access_token";
    private final Grant grant;
    private CreateApiKeyRequest apiKey;

    public GrantApiKeyRequest() {
        this.grant = new Grant();
        this.apiKey = new CreateApiKeyRequest();
    }

    public GrantApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.grant = new Grant(in);
        this.apiKey = new CreateApiKeyRequest(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.grant.writeTo(out);
        this.apiKey.writeTo(out);
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.apiKey.getRefreshPolicy();
    }

    public void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.apiKey.setRefreshPolicy(refreshPolicy);
    }

    public Grant getGrant() {
        return this.grant;
    }

    public CreateApiKeyRequest getApiKeyRequest() {
        return this.apiKey;
    }

    public void setApiKeyRequest(CreateApiKeyRequest apiKeyRequest) {
        this.apiKey = Objects.requireNonNull(apiKeyRequest, "Cannot set a null api_key");
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = this.apiKey.validate();
        if (this.grant.type == null) {
            validationException = ValidateActions.addValidationError((String)"[grant_type] is required", (ActionRequestValidationException)validationException);
        } else if (this.grant.type.equals(PASSWORD_GRANT_TYPE)) {
            validationException = this.validateRequiredField("username", this.grant.username, validationException);
            validationException = this.validateRequiredField(PASSWORD_GRANT_TYPE, (CharSequence)this.grant.password, validationException);
            validationException = this.validateUnsupportedField(ACCESS_TOKEN_GRANT_TYPE, (CharSequence)this.grant.accessToken, validationException);
        } else if (this.grant.type.equals(ACCESS_TOKEN_GRANT_TYPE)) {
            validationException = this.validateRequiredField(ACCESS_TOKEN_GRANT_TYPE, (CharSequence)this.grant.accessToken, validationException);
            validationException = this.validateUnsupportedField("username", this.grant.username, validationException);
            validationException = this.validateUnsupportedField(PASSWORD_GRANT_TYPE, (CharSequence)this.grant.password, validationException);
        } else {
            validationException = ValidateActions.addValidationError((String)("grant_type [" + this.grant.type + "] is not supported"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    private ActionRequestValidationException validateRequiredField(String fieldName, CharSequence fieldValue, ActionRequestValidationException validationException) {
        if (fieldValue == null || fieldValue.length() == 0) {
            return ValidateActions.addValidationError((String)("[" + fieldName + "] is required for grant_type [" + this.grant.type + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    private ActionRequestValidationException validateUnsupportedField(String fieldName, CharSequence fieldValue, ActionRequestValidationException validationException) {
        if (fieldValue != null && fieldValue.length() > 0) {
            return ValidateActions.addValidationError((String)("[" + fieldName + "] is not supported for grant_type [" + this.grant.type + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public static class Grant
    implements Writeable {
        private String type;
        private String username;
        private SecureString password;
        private SecureString accessToken;

        public Grant() {
        }

        public Grant(StreamInput in) throws IOException {
            this.type = in.readString();
            this.username = in.readOptionalString();
            this.password = in.readOptionalSecureString();
            this.accessToken = in.readOptionalSecureString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeOptionalString(this.username);
            out.writeOptionalSecureString(this.password);
            out.writeOptionalSecureString(this.accessToken);
        }

        public String getType() {
            return this.type;
        }

        public String getUsername() {
            return this.username;
        }

        public SecureString getPassword() {
            return this.password;
        }

        public SecureString getAccessToken() {
            return this.accessToken;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(SecureString password) {
            this.password = password;
        }

        public void setAccessToken(SecureString accessToken) {
            this.accessToken = accessToken;
        }
    }
}

