/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.searchablesnapshots;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotFeatureSetUsage;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsConstants;

public class SearchableSnapshotsFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;

    @Inject
    public SearchableSnapshotsFeatureSet(@Nullable XPackLicenseState licenseState, ClusterService clusterService) {
        this.licenseState = licenseState;
        this.clusterService = clusterService;
    }

    @Override
    public String name() {
        return "searchable_snapshots";
    }

    @Override
    public boolean available() {
        return this.licenseState.isAllowed(XPackLicenseState.Feature.SEARCHABLE_SNAPSHOTS);
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    @Override
    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        int numSnapIndices = 0;
        for (IndexMetadata indexMetadata : state.metadata()) {
            if (!SearchableSnapshotsConstants.isSearchableSnapshotStore(indexMetadata.getSettings())) continue;
            ++numSnapIndices;
        }
        listener.onResponse((Object)new SearchableSnapshotFeatureSetUsage(this.available(), numSnapIndices));
    }
}

