/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public final class MlIndexAndAlias {
    private static final Logger logger = LogManager.getLogger(MlIndexAndAlias.class);
    static final Version HIDDEN_INTRODUCED_VERSION = Version.V_7_7_0;
    static final Comparator<String> INDEX_NAME_COMPARATOR = new Comparator<String>(){
        private final Pattern HAS_SIX_DIGIT_SUFFIX = Pattern.compile("\\d{6}");

        @Override
        public int compare(String index1, String index2) {
            String[] index1Parts = index1.split("-");
            String index1Suffix = index1Parts[index1Parts.length - 1];
            boolean index1HasSixDigitsSuffix = this.HAS_SIX_DIGIT_SUFFIX.matcher(index1Suffix).matches();
            String[] index2Parts = index2.split("-");
            String index2Suffix = index2Parts[index2Parts.length - 1];
            boolean index2HasSixDigitsSuffix = this.HAS_SIX_DIGIT_SUFFIX.matcher(index2Suffix).matches();
            if (index1HasSixDigitsSuffix && index2HasSixDigitsSuffix) {
                return index1Suffix.compareTo(index2Suffix);
            }
            if (index1HasSixDigitsSuffix != index2HasSixDigitsSuffix) {
                return Boolean.compare(index1HasSixDigitsSuffix, index2HasSixDigitsSuffix);
            }
            return index1.compareTo(index2);
        }
    };

    private MlIndexAndAlias() {
    }

    public static void createIndexAndAliasIfNecessary(Client client, ClusterState clusterState, IndexNameExpressionResolver resolver, String indexPatternPrefix, String alias, ActionListener<Boolean> finalListener) {
        Optional indexPointedByCurrentWriteAlias;
        ActionListener indexCreatedListener = ActionListener.wrap(created -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, alias, finalListener);
            } else {
                finalListener.onResponse((Object)false);
            }
        }, arg_0 -> finalListener.onFailure(arg_0));
        boolean isHiddenAttributeAvailable = clusterState.nodes().getMinNodeVersion().onOrAfter(HIDDEN_INTRODUCED_VERSION);
        String legacyIndexWithoutSuffix = indexPatternPrefix;
        String indexPattern = indexPatternPrefix + "*";
        String firstConcreteIndex = indexPatternPrefix + "-000001";
        String[] concreteIndexNames = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{indexPattern});
        Optional<Object> optional = indexPointedByCurrentWriteAlias = clusterState.getMetadata().hasAlias(alias) ? ((IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(alias)).getIndices().stream().findFirst() : Optional.empty();
        if (concreteIndexNames.length == 0) {
            if (!indexPointedByCurrentWriteAlias.isPresent()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, isHiddenAttributeAvailable, (ActionListener<Boolean>)indexCreatedListener);
                return;
            }
            logger.error("There are no indices matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (concreteIndexNames.length == 1 && concreteIndexNames[0].equals(legacyIndexWithoutSuffix)) {
            if (!indexPointedByCurrentWriteAlias.isPresent()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, isHiddenAttributeAvailable, (ActionListener<Boolean>)indexCreatedListener);
                return;
            }
            if (((IndexMetadata)indexPointedByCurrentWriteAlias.get()).getIndex().getName().equals(legacyIndexWithoutSuffix)) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, false, isHiddenAttributeAvailable, (ActionListener<Boolean>)ActionListener.wrap(unused -> MlIndexAndAlias.updateWriteAlias(client, alias, legacyIndexWithoutSuffix, firstConcreteIndex, isHiddenAttributeAvailable, (ActionListener<Boolean>)indexCreatedListener), arg_0 -> finalListener.onFailure(arg_0)));
                return;
            }
            logger.error("There is exactly one index (i.e. '{}') matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)legacyIndexWithoutSuffix, (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (!indexPointedByCurrentWriteAlias.isPresent()) {
            assert (concreteIndexNames.length > 0);
            String latestConcreteIndexName = Arrays.stream(concreteIndexNames).max(INDEX_NAME_COMPARATOR).get();
            MlIndexAndAlias.updateWriteAlias(client, alias, null, latestConcreteIndexName, isHiddenAttributeAvailable, finalListener);
            return;
        }
        finalListener.onResponse((Object)false);
    }

    private static void waitForShardsReady(Client client, String index, ActionListener<Boolean> listener) {
        ClusterHealthRequest healthRequest = Requests.clusterHealthRequest((String[])new String[]{index}).waitForYellowStatus().waitForNoRelocatingShards(true).waitForNoInitializingShards(true);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", healthRequest, ActionListener.wrap(response -> listener.onResponse((Object)(!response.isTimedOut() ? 1 : 0)), arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((ClusterAdminClient)client.admin().cluster()).health(arg_0, arg_1));
    }

    private static void createFirstConcreteIndex(Client client, String index, String alias, boolean addAlias, boolean isHiddenAttributeAvailable, ActionListener<Boolean> listener) {
        logger.info("About to create first concrete index [{}] with alias [{}]", (Object)index, (Object)alias);
        CreateIndexRequestBuilder requestBuilder = client.admin().indices().prepareCreate(index);
        if (addAlias) {
            Alias newAlias = new Alias(alias);
            if (isHiddenAttributeAvailable) {
                newAlias.isHidden(Boolean.valueOf(true));
            }
            requestBuilder.addAlias(newAlias);
        }
        CreateIndexRequest request = (CreateIndexRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(createIndexResponse -> listener.onResponse((Object)true), createIndexFailure -> {
            if (ExceptionsHelper.unwrapCause(createIndexFailure) instanceof ResourceAlreadyExistsException) {
                MlIndexAndAlias.updateWriteAlias(client, alias, null, index, isHiddenAttributeAvailable, listener);
            } else {
                listener.onFailure(createIndexFailure);
            }
        }), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
    }

    private static void updateWriteAlias(Client client, String alias, @Nullable String currentIndex, String newIndex, boolean isHiddenAttributeAvailable, ActionListener<Boolean> listener) {
        logger.info("About to move write alias [{}] from index [{}] to index [{}]", (Object)alias, (Object)currentIndex, (Object)newIndex);
        IndicesAliasesRequest.AliasActions addNewAliasAction = IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(alias);
        if (isHiddenAttributeAvailable) {
            addNewAliasAction.isHidden(Boolean.valueOf(true));
        }
        IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases().addAliasAction(addNewAliasAction);
        if (currentIndex != null) {
            requestBuilder.removeAlias(currentIndex, alias);
        }
        IndicesAliasesRequest request = (IndicesAliasesRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(resp -> listener.onResponse((Object)resp.isAcknowledged()), arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
    }
}

