/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.job.config.CategorizationAnalyzerConfig;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.DetectorFunction;
import org.elasticsearch.xpack.core.ml.job.config.PerPartitionCategorizationConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class AnalysisConfig
implements ToXContentObject,
Writeable {
    public static final ParseField ANALYSIS_CONFIG = new ParseField("analysis_config", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField CATEGORIZATION_FIELD_NAME = new ParseField("categorization_field_name", new String[0]);
    public static final ParseField CATEGORIZATION_FILTERS = new ParseField("categorization_filters", new String[0]);
    public static final ParseField CATEGORIZATION_ANALYZER = CategorizationAnalyzerConfig.CATEGORIZATION_ANALYZER;
    public static final ParseField PER_PARTITION_CATEGORIZATION = new ParseField("per_partition_categorization", new String[0]);
    public static final ParseField LATENCY = new ParseField("latency", new String[0]);
    public static final ParseField SUMMARY_COUNT_FIELD_NAME = new ParseField("summary_count_field_name", new String[0]);
    public static final ParseField DETECTORS = new ParseField("detectors", new String[0]);
    public static final ParseField INFLUENCERS = new ParseField("influencers", new String[0]);
    public static final ParseField MULTIVARIATE_BY_FIELDS = new ParseField("multivariate_by_fields", new String[0]);
    public static final String ML_CATEGORY_FIELD = "mlcategory";
    public static final Set<String> AUTO_CREATED_FIELDS = new HashSet<String>(Collections.singletonList("mlcategory"));
    public static final ConstructingObjectParser<Builder, Void> LENIENT_PARSER = AnalysisConfig.createParser(true);
    public static final ConstructingObjectParser<Builder, Void> STRICT_PARSER = AnalysisConfig.createParser(false);
    private final TimeValue bucketSpan;
    private final String categorizationFieldName;
    private final List<String> categorizationFilters;
    private final CategorizationAnalyzerConfig categorizationAnalyzerConfig;
    private final PerPartitionCategorizationConfig perPartitionCategorizationConfig;
    private final TimeValue latency;
    private final String summaryCountFieldName;
    private final List<Detector> detectors;
    private final List<String> influencers;
    private final Boolean multivariateByFields;

    private static ConstructingObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(ANALYSIS_CONFIG.getPreferredName(), ignoreUnknownFields, a -> new Builder((List)a[0]));
        parser.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> ((Detector.Builder)(ignoreUnknownFields ? Detector.LENIENT_PARSER : Detector.STRICT_PARSER).apply(p, c)).build(), DETECTORS);
        parser.declareString((builder, val) -> builder.setBucketSpan(TimeValue.parseTimeValue((String)val, (String)BUCKET_SPAN.getPreferredName())), BUCKET_SPAN);
        parser.declareString(Builder::setCategorizationFieldName, CATEGORIZATION_FIELD_NAME);
        parser.declareStringArray(Builder::setCategorizationFilters, CATEGORIZATION_FILTERS);
        parser.declareField(Builder::setCategorizationAnalyzerConfig, (p, c) -> CategorizationAnalyzerConfig.buildFromXContentFragment(p, ignoreUnknownFields), CATEGORIZATION_ANALYZER, ObjectParser.ValueType.OBJECT_OR_STRING);
        parser.declareObject(Builder::setPerPartitionCategorizationConfig, ignoreUnknownFields ? PerPartitionCategorizationConfig.LENIENT_PARSER : PerPartitionCategorizationConfig.STRICT_PARSER, PER_PARTITION_CATEGORIZATION);
        parser.declareString((builder, val) -> builder.setLatency(TimeValue.parseTimeValue((String)val, (String)LATENCY.getPreferredName())), LATENCY);
        parser.declareString(Builder::setSummaryCountFieldName, SUMMARY_COUNT_FIELD_NAME);
        parser.declareStringArray(Builder::setInfluencers, INFLUENCERS);
        parser.declareBoolean(Builder::setMultivariateByFields, MULTIVARIATE_BY_FIELDS);
        return parser;
    }

    private AnalysisConfig(TimeValue bucketSpan, String categorizationFieldName, List<String> categorizationFilters, CategorizationAnalyzerConfig categorizationAnalyzerConfig, PerPartitionCategorizationConfig perPartitionCategorizationConfig, TimeValue latency, String summaryCountFieldName, List<Detector> detectors, List<String> influencers, Boolean multivariateByFields) {
        this.detectors = detectors;
        this.bucketSpan = bucketSpan;
        this.latency = latency;
        this.categorizationFieldName = categorizationFieldName;
        this.categorizationAnalyzerConfig = categorizationAnalyzerConfig;
        this.categorizationFilters = categorizationFilters == null ? null : Collections.unmodifiableList(categorizationFilters);
        this.perPartitionCategorizationConfig = perPartitionCategorizationConfig;
        this.summaryCountFieldName = summaryCountFieldName;
        this.influencers = Collections.unmodifiableList(influencers);
        this.multivariateByFields = multivariateByFields;
    }

    public AnalysisConfig(StreamInput in) throws IOException {
        this.bucketSpan = in.readTimeValue();
        this.categorizationFieldName = in.readOptionalString();
        this.categorizationFilters = in.readBoolean() ? Collections.unmodifiableList(in.readStringList()) : null;
        this.categorizationAnalyzerConfig = (CategorizationAnalyzerConfig)in.readOptionalWriteable(CategorizationAnalyzerConfig::new);
        this.perPartitionCategorizationConfig = in.getVersion().onOrAfter(Version.V_7_9_0) ? new PerPartitionCategorizationConfig(in) : new PerPartitionCategorizationConfig();
        this.latency = in.readOptionalTimeValue();
        this.summaryCountFieldName = in.readOptionalString();
        this.detectors = Collections.unmodifiableList(in.readList(Detector::new));
        this.influencers = Collections.unmodifiableList(in.readStringList());
        this.multivariateByFields = in.readOptionalBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeTimeValue(this.bucketSpan);
        out.writeOptionalString(this.categorizationFieldName);
        if (this.categorizationFilters != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.categorizationFilters);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable((Writeable)this.categorizationAnalyzerConfig);
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            this.perPartitionCategorizationConfig.writeTo(out);
        }
        out.writeOptionalTimeValue(this.latency);
        out.writeOptionalString(this.summaryCountFieldName);
        out.writeList(this.detectors);
        out.writeStringCollection(this.influencers);
        out.writeOptionalBoolean(this.multivariateByFields);
    }

    public TimeValue getBucketSpan() {
        return this.bucketSpan;
    }

    public String getCategorizationFieldName() {
        return this.categorizationFieldName;
    }

    public List<String> getCategorizationFilters() {
        return this.categorizationFilters;
    }

    public CategorizationAnalyzerConfig getCategorizationAnalyzerConfig() {
        return this.categorizationAnalyzerConfig;
    }

    public PerPartitionCategorizationConfig getPerPartitionCategorizationConfig() {
        return this.perPartitionCategorizationConfig;
    }

    public TimeValue getLatency() {
        return this.latency;
    }

    public String getSummaryCountFieldName() {
        return this.summaryCountFieldName;
    }

    public List<Detector> getDetectors() {
        return this.detectors;
    }

    public List<String> getInfluencers() {
        return this.influencers;
    }

    public Set<String> termFields() {
        return AnalysisConfig.termFields(this.getDetectors(), this.getInfluencers());
    }

    static SortedSet<String> termFields(List<Detector> detectors, List<String> influencers) {
        TreeSet<String> termFields = new TreeSet<String>();
        detectors.forEach(d -> termFields.addAll(d.getByOverPartitionTerms()));
        for (String i : influencers) {
            AnalysisConfig.addIfNotNull(termFields, i);
        }
        termFields.remove("");
        return termFields;
    }

    public Set<String> extractReferencedFilters() {
        return this.detectors.stream().map(Detector::extractReferencedFilters).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Boolean getMultivariateByFields() {
        return this.multivariateByFields;
    }

    public Set<String> analysisFields() {
        Set<String> analysisFields = this.termFields();
        AnalysisConfig.addIfNotNull(analysisFields, this.categorizationFieldName);
        AnalysisConfig.addIfNotNull(analysisFields, this.summaryCountFieldName);
        for (Detector d : this.getDetectors()) {
            AnalysisConfig.addIfNotNull(analysisFields, d.getFieldName());
        }
        analysisFields.remove("");
        return analysisFields;
    }

    private static void addIfNotNull(Set<String> fields, String field) {
        if (field != null) {
            fields.add(field);
        }
    }

    public List<String> fields() {
        return this.collectNonNullAndNonEmptyDetectorFields(Detector::getFieldName);
    }

    private List<String> collectNonNullAndNonEmptyDetectorFields(Function<Detector, String> fieldGetter) {
        HashSet<String> fields = new HashSet<String>();
        for (Detector d : this.getDetectors()) {
            AnalysisConfig.addIfNotNull(fields, fieldGetter.apply(d));
        }
        fields.remove("");
        return new ArrayList<String>(fields);
    }

    public List<String> byFields() {
        return this.collectNonNullAndNonEmptyDetectorFields(Detector::getByFieldName);
    }

    public List<String> overFields() {
        return this.collectNonNullAndNonEmptyDetectorFields(Detector::getOverFieldName);
    }

    public List<String> partitionFields() {
        return this.collectNonNullAndNonEmptyDetectorFields(Detector::getPartitionFieldName);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan.getStringRep());
        if (this.categorizationFieldName != null) {
            builder.field(CATEGORIZATION_FIELD_NAME.getPreferredName(), this.categorizationFieldName);
        }
        if (this.categorizationFilters != null) {
            builder.field(CATEGORIZATION_FILTERS.getPreferredName(), this.categorizationFilters);
        }
        if (this.categorizationAnalyzerConfig != null) {
            this.categorizationAnalyzerConfig.toXContent(builder, params);
        }
        if (this.categorizationFieldName != null) {
            builder.field(PER_PARTITION_CATEGORIZATION.getPreferredName(), (ToXContent)this.perPartitionCategorizationConfig);
        }
        if (this.latency != null) {
            builder.field(LATENCY.getPreferredName(), this.latency.getStringRep());
        }
        if (this.summaryCountFieldName != null) {
            builder.field(SUMMARY_COUNT_FIELD_NAME.getPreferredName(), this.summaryCountFieldName);
        }
        builder.startArray(DETECTORS.getPreferredName());
        for (Detector detector : this.detectors) {
            detector.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(INFLUENCERS.getPreferredName(), this.influencers);
        if (this.multivariateByFields != null) {
            builder.field(MULTIVARIATE_BY_FIELDS.getPreferredName(), this.multivariateByFields);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalysisConfig that = (AnalysisConfig)o;
        return Objects.equals(this.latency, that.latency) && Objects.equals(this.bucketSpan, that.bucketSpan) && Objects.equals(this.categorizationFieldName, that.categorizationFieldName) && Objects.equals(this.categorizationFilters, that.categorizationFilters) && Objects.equals(this.categorizationAnalyzerConfig, that.categorizationAnalyzerConfig) && Objects.equals(this.perPartitionCategorizationConfig, that.perPartitionCategorizationConfig) && Objects.equals(this.summaryCountFieldName, that.summaryCountFieldName) && Objects.equals(this.detectors, that.detectors) && Objects.equals(this.influencers, that.influencers) && Objects.equals(this.multivariateByFields, that.multivariateByFields);
    }

    public int hashCode() {
        return Objects.hash(this.bucketSpan, this.categorizationFieldName, this.categorizationFilters, this.categorizationAnalyzerConfig, this.perPartitionCategorizationConfig, this.latency, this.summaryCountFieldName, this.detectors, this.influencers, this.multivariateByFields);
    }

    public static class Builder {
        public static final TimeValue DEFAULT_BUCKET_SPAN = TimeValue.timeValueMinutes((long)5L);
        private List<Detector> detectors;
        private TimeValue bucketSpan = DEFAULT_BUCKET_SPAN;
        private TimeValue latency;
        private String categorizationFieldName;
        private List<String> categorizationFilters;
        private CategorizationAnalyzerConfig categorizationAnalyzerConfig;
        private PerPartitionCategorizationConfig perPartitionCategorizationConfig = new PerPartitionCategorizationConfig();
        private String summaryCountFieldName;
        private List<String> influencers = new ArrayList<String>();
        private Boolean multivariateByFields;

        public Builder(List<Detector> detectors) {
            this.setDetectors(detectors);
        }

        public Builder(AnalysisConfig analysisConfig) {
            this.detectors = new ArrayList<Detector>(analysisConfig.detectors);
            this.bucketSpan = analysisConfig.bucketSpan;
            this.latency = analysisConfig.latency;
            this.categorizationFieldName = analysisConfig.categorizationFieldName;
            this.categorizationFilters = analysisConfig.categorizationFilters == null ? null : new ArrayList(analysisConfig.categorizationFilters);
            this.categorizationAnalyzerConfig = analysisConfig.categorizationAnalyzerConfig;
            this.perPartitionCategorizationConfig = analysisConfig.perPartitionCategorizationConfig;
            this.summaryCountFieldName = analysisConfig.summaryCountFieldName;
            this.influencers = new ArrayList<String>(analysisConfig.influencers);
            this.multivariateByFields = analysisConfig.multivariateByFields;
        }

        public Builder setDetectors(List<Detector> detectors) {
            if (detectors == null) {
                this.detectors = null;
                return this;
            }
            int detectorIndex = 0;
            ArrayList<Detector> sequentialIndexDetectors = new ArrayList<Detector>(detectors.size());
            for (Detector origDetector : detectors) {
                Detector.Builder builder = new Detector.Builder(origDetector);
                builder.setDetectorIndex(detectorIndex++);
                sequentialIndexDetectors.add(builder.build());
            }
            this.detectors = sequentialIndexDetectors;
            return this;
        }

        public Builder setDetector(int detectorIndex, Detector detector) {
            this.detectors.set(detectorIndex, detector);
            return this;
        }

        public Builder setBucketSpan(TimeValue bucketSpan) {
            this.bucketSpan = bucketSpan;
            return this;
        }

        public Builder setLatency(TimeValue latency) {
            this.latency = latency;
            return this;
        }

        public Builder setCategorizationFieldName(String categorizationFieldName) {
            this.categorizationFieldName = categorizationFieldName;
            return this;
        }

        public Builder setCategorizationFilters(List<String> categorizationFilters) {
            this.categorizationFilters = categorizationFilters;
            return this;
        }

        public Builder setCategorizationAnalyzerConfig(CategorizationAnalyzerConfig categorizationAnalyzerConfig) {
            this.categorizationAnalyzerConfig = categorizationAnalyzerConfig;
            return this;
        }

        public Builder setPerPartitionCategorizationConfig(PerPartitionCategorizationConfig perPartitionCategorizationConfig) {
            this.perPartitionCategorizationConfig = ExceptionsHelper.requireNonNull(perPartitionCategorizationConfig, PER_PARTITION_CATEGORIZATION.getPreferredName());
            return this;
        }

        public Builder setSummaryCountFieldName(String summaryCountFieldName) {
            this.summaryCountFieldName = summaryCountFieldName;
            return this;
        }

        public Builder setInfluencers(List<String> influencers) {
            this.influencers = ExceptionsHelper.requireNonNull(influencers, INFLUENCERS.getPreferredName());
            return this;
        }

        public Builder setMultivariateByFields(Boolean multivariateByFields) {
            this.multivariateByFields = multivariateByFields;
            return this;
        }

        public AnalysisConfig build() {
            TimeUtils.checkPositiveMultiple(this.bucketSpan, TimeUnit.SECONDS, BUCKET_SPAN);
            if (this.latency != null) {
                TimeUtils.checkNonNegativeMultiple(this.latency, TimeUnit.SECONDS, LATENCY);
            }
            this.verifyDetectorAreDefined();
            Detector.Builder.verifyFieldName(this.summaryCountFieldName);
            Detector.Builder.verifyFieldName(this.categorizationFieldName);
            this.verifyMlCategoryIsUsedWhenCategorizationFieldNameIsSet();
            this.verifyCategorizationAnalyzer();
            this.verifyCategorizationFilters();
            this.verifyConfigConsistentWithPerPartitionCategorization();
            this.verifyNoMetricFunctionsWhenSummaryCountFieldNameIsSet();
            this.verifyNoInconsistentNestedFieldNames();
            return new AnalysisConfig(this.bucketSpan, this.categorizationFieldName, this.categorizationFilters, this.categorizationAnalyzerConfig, this.perPartitionCategorizationConfig, this.latency, this.summaryCountFieldName, this.detectors, this.influencers, this.multivariateByFields);
        }

        private void verifyConfigConsistentWithPerPartitionCategorization() {
            if (!this.perPartitionCategorizationConfig.isEnabled()) {
                return;
            }
            if (this.categorizationFieldName == null) {
                throw ExceptionsHelper.badRequestException(CATEGORIZATION_FIELD_NAME.getPreferredName() + " must be set when per-partition categorization is enabled", new Object[0]);
            }
            AtomicReference singlePartitionFieldName = new AtomicReference();
            this.detectors.forEach(d -> {
                String previousPartitionFieldName;
                String thisDetectorPartitionFieldName = d.getPartitionFieldName();
                if (d.getByOverPartitionTerms().contains(AnalysisConfig.ML_CATEGORY_FIELD)) {
                    if (AnalysisConfig.ML_CATEGORY_FIELD.equals(d.getPartitionFieldName())) {
                        throw ExceptionsHelper.badRequestException("mlcategory cannot be used as a " + Detector.PARTITION_FIELD_NAME_FIELD.getPreferredName() + " when per-partition categorization is enabled", new Object[0]);
                    }
                    if (thisDetectorPartitionFieldName == null) {
                        throw ExceptionsHelper.badRequestException(Detector.PARTITION_FIELD_NAME_FIELD.getPreferredName() + " must be set for detectors that reference " + AnalysisConfig.ML_CATEGORY_FIELD + " when per-partition categorization is enabled", new Object[0]);
                    }
                }
                if (thisDetectorPartitionFieldName != null && (previousPartitionFieldName = singlePartitionFieldName.getAndSet(thisDetectorPartitionFieldName)) != null && !previousPartitionFieldName.equals(thisDetectorPartitionFieldName)) {
                    throw ExceptionsHelper.badRequestException(Detector.PARTITION_FIELD_NAME_FIELD.getPreferredName() + " cannot vary between detectors when per-partition categorization is enabled: [" + previousPartitionFieldName + "] and [" + thisDetectorPartitionFieldName + "] are used", new Object[0]);
                }
            });
        }

        private void verifyNoMetricFunctionsWhenSummaryCountFieldNameIsSet() {
            if (!Strings.isNullOrEmpty((String)this.summaryCountFieldName) && this.detectors.stream().anyMatch(d -> DetectorFunction.METRIC.equals((Object)d.getFunction()))) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("The ''{0}'' function cannot be used in jobs that will take pre-summarized input", new Object[]{DetectorFunction.METRIC}), new Object[0]);
            }
        }

        private void verifyDetectorAreDefined() {
            if (this.detectors == null || this.detectors.isEmpty()) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("No detectors configured"), new Object[0]);
            }
        }

        private void verifyNoInconsistentNestedFieldNames() {
            SortedSet<String> termFields = AnalysisConfig.termFields(this.detectors, this.influencers);
            String prevTermField = null;
            for (String termField : termFields) {
                if (prevTermField != null && termField.startsWith(prevTermField + ".")) {
                    throw ExceptionsHelper.badRequestException("Fields [" + prevTermField + "] and [" + termField + "] cannot both be used in the same analysis_config", new Object[0]);
                }
                prevTermField = termField;
            }
        }

        private void verifyMlCategoryIsUsedWhenCategorizationFieldNameIsSet() {
            TreeSet byOverPartitionFields = new TreeSet();
            this.detectors.forEach(d -> byOverPartitionFields.addAll(d.getByOverPartitionTerms()));
            boolean isMlCategoryUsed = byOverPartitionFields.contains(AnalysisConfig.ML_CATEGORY_FIELD);
            if (isMlCategoryUsed && this.categorizationFieldName == null) {
                throw ExceptionsHelper.badRequestException(CATEGORIZATION_FIELD_NAME.getPreferredName() + " must be set for " + AnalysisConfig.ML_CATEGORY_FIELD + " to be available", new Object[0]);
            }
            if (this.categorizationFieldName != null && !isMlCategoryUsed) {
                throw ExceptionsHelper.badRequestException(CATEGORIZATION_FIELD_NAME.getPreferredName() + " is set but " + AnalysisConfig.ML_CATEGORY_FIELD + " is not used in any detector by/over/partition field", new Object[0]);
            }
        }

        private void verifyCategorizationAnalyzer() {
            if (this.categorizationAnalyzerConfig == null) {
                return;
            }
            this.verifyCategorizationFieldNameSetIfAnalyzerIsSet();
        }

        private void verifyCategorizationFieldNameSetIfAnalyzerIsSet() {
            if (this.categorizationFieldName == null) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("categorization_analyzer requires setting categorization_field_name"), new Object[0]);
            }
        }

        private void verifyCategorizationFilters() {
            if (this.categorizationFilters == null || this.categorizationFilters.isEmpty()) {
                return;
            }
            this.verifyCategorizationAnalyzerNotSetIfFiltersAreSet();
            this.verifyCategorizationFieldNameSetIfFiltersAreSet();
            this.verifyCategorizationFiltersAreDistinct();
            this.verifyCategorizationFiltersContainNoneEmpty();
            this.verifyCategorizationFiltersAreValidRegex();
        }

        private void verifyCategorizationAnalyzerNotSetIfFiltersAreSet() {
            if (this.categorizationAnalyzerConfig != null) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("categorization_filters cannot be used with categorization_analyzer - instead specify them as pattern_replace char_filters in the analyzer"), new Object[0]);
            }
        }

        private void verifyCategorizationFieldNameSetIfFiltersAreSet() {
            if (this.categorizationFieldName == null) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("categorization_filters require setting categorization_field_name"), new Object[0]);
            }
        }

        private void verifyCategorizationFiltersAreDistinct() {
            if (this.categorizationFilters.stream().distinct().count() != (long)this.categorizationFilters.size()) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("categorization_filters contain duplicates"), new Object[0]);
            }
        }

        private void verifyCategorizationFiltersContainNoneEmpty() {
            if (this.categorizationFilters.stream().anyMatch(String::isEmpty)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("categorization_filters are not allowed to contain empty strings"), new Object[0]);
            }
        }

        private void verifyCategorizationFiltersAreValidRegex() {
            for (String filter : this.categorizationFilters) {
                if (Builder.isValidRegex(filter)) continue;
                throw ExceptionsHelper.badRequestException(Messages.getMessage("categorization_filters contains invalid regular expression ''{0}''", filter), new Object[0]);
            }
        }

        private static boolean isValidRegex(String exp) {
            try {
                Pattern.compile(exp);
                return true;
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }
    }
}

