/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class FeatureImportance
implements Writeable,
ToXContentObject {
    private final Map<String, Double> classImportance;
    private final double importance;
    private final String featureName;
    static final String IMPORTANCE = "importance";
    static final String FEATURE_NAME = "feature_name";
    static final String CLASS_IMPORTANCE = "class_importance";
    private static final ConstructingObjectParser<FeatureImportance, Void> PARSER = new ConstructingObjectParser("feature_importance", a -> new FeatureImportance((String)a[0], (Double)a[1], (Map)a[2]));

    public static FeatureImportance forRegression(String featureName, double importance) {
        return new FeatureImportance(featureName, importance, null);
    }

    public static FeatureImportance forClassification(String featureName, Map<String, Double> classImportance) {
        return new FeatureImportance(featureName, classImportance.values().stream().mapToDouble(Math::abs).sum(), classImportance);
    }

    public static FeatureImportance fromXContent(XContentParser parser) {
        return (FeatureImportance)PARSER.apply(parser, null);
    }

    FeatureImportance(String featureName, double importance, Map<String, Double> classImportance) {
        this.featureName = Objects.requireNonNull(featureName);
        this.importance = importance;
        this.classImportance = classImportance == null ? null : Collections.unmodifiableMap(classImportance);
    }

    public FeatureImportance(StreamInput in) throws IOException {
        this.featureName = in.readString();
        this.importance = in.readDouble();
        this.classImportance = in.readBoolean() ? in.readMap(StreamInput::readString, StreamInput::readDouble) : null;
    }

    public Map<String, Double> getClassImportance() {
        return this.classImportance;
    }

    public double getImportance() {
        return this.importance;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureName);
        out.writeDouble(this.importance);
        out.writeBoolean(this.classImportance != null);
        if (this.classImportance != null) {
            out.writeMap(this.classImportance, StreamOutput::writeString, StreamOutput::writeDouble);
        }
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(FEATURE_NAME, this.featureName);
        map.put(IMPORTANCE, this.importance);
        if (this.classImportance != null) {
            this.classImportance.forEach(map::put);
        }
        return map;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FEATURE_NAME, this.featureName);
        builder.field(IMPORTANCE, this.importance);
        if (this.classImportance != null && !this.classImportance.isEmpty()) {
            builder.startObject(CLASS_IMPORTANCE);
            for (Map.Entry<String, Double> entry : this.classImportance.entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FeatureImportance that = (FeatureImportance)object;
        return Objects.equals(this.featureName, that.featureName) && Objects.equals(this.importance, that.importance) && Objects.equals(this.classImportance, that.classImportance);
    }

    public int hashCode() {
        return Objects.hash(this.featureName, this.importance, this.classImportance);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FEATURE_NAME, new String[0]));
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), new ParseField(IMPORTANCE, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(HashMap::new, XContentParser::doubleValue), new ParseField(CLASS_IMPORTANCE, new String[0]));
    }
}

