/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding;

import java.util.OptionalInt;
import org.apache.lucene.util.Counter;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding.DiscreteFeatureValue;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding.FeatureExtractor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding.FeatureValue;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding.ScriptCode;

public final class ScriptFeatureExtractor
implements FeatureExtractor {
    private static ScriptCode getScriptIdOfFirstLetter(String text) {
        OptionalInt optionalCp = text.codePoints().filter(Character::isLetter).findFirst();
        if (!optionalCp.isPresent()) {
            return ScriptCode.Common;
        }
        Character.UnicodeScript unicodeScript = Character.UnicodeScript.of(optionalCp.getAsInt());
        return ScriptCode.unicodeScriptToULScript(unicodeScript);
    }

    static int getScriptFeatureValue(String text) {
        ScriptCode scriptCode = ScriptFeatureExtractor.getScriptIdOfFirstLetter(text);
        if (scriptCode != ScriptCode.Hani) {
            return scriptCode.toInt();
        }
        Counter hangulCounter = Counter.newCounter();
        Counter nonHangulCounter = Counter.newCounter();
        text.codePoints().forEach(cp -> {
            if (Character.isSpaceChar(cp)) {
                return;
            }
            if (Character.UnicodeScript.of(cp).equals((Object)Character.UnicodeScript.HANGUL)) {
                hangulCounter.addAndGet(1L);
            } else {
                nonHangulCounter.addAndGet(1L);
            }
        });
        return hangulCounter.get() > nonHangulCounter.get() ? ScriptCode.MAX_SCRIPT_CODE.toInt() : ScriptCode.Hani.toInt();
    }

    @Override
    public FeatureValue[] extractFeatures(String text) {
        return new FeatureValue[]{new DiscreteFeatureValue(ScriptFeatureExtractor.getScriptFeatureValue(text))};
    }
}

