/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.StrictlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class FrequencyEncoding
implements LenientlyParsedPreProcessor,
StrictlyParsedPreProcessor {
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FrequencyEncoding.class);
    public static final ParseField NAME = new ParseField("frequency_encoding", new String[0]);
    public static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
    public static final ParseField FREQUENCY_MAP = new ParseField("frequency_map", new String[0]);
    public static final ConstructingObjectParser<FrequencyEncoding, Void> STRICT_PARSER = FrequencyEncoding.createParser(false);
    public static final ConstructingObjectParser<FrequencyEncoding, Void> LENIENT_PARSER = FrequencyEncoding.createParser(true);
    private final String field;
    private final String featureName;
    private final Map<String, Double> frequencyMap;

    private static ConstructingObjectParser<FrequencyEncoding, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new FrequencyEncoding((String)a[0], (String)a[1], (Map)a[2]));
        parser.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(HashMap::new, XContentParser::doubleValue), FREQUENCY_MAP);
        return parser;
    }

    public static FrequencyEncoding fromXContentStrict(XContentParser parser) {
        return (FrequencyEncoding)STRICT_PARSER.apply(parser, null);
    }

    public static FrequencyEncoding fromXContentLenient(XContentParser parser) {
        return (FrequencyEncoding)LENIENT_PARSER.apply(parser, null);
    }

    public FrequencyEncoding(String field, String featureName, Map<String, Double> frequencyMap) {
        this.field = ExceptionsHelper.requireNonNull(field, FIELD);
        this.featureName = ExceptionsHelper.requireNonNull(featureName, FEATURE_NAME);
        this.frequencyMap = Collections.unmodifiableMap(ExceptionsHelper.requireNonNull(frequencyMap, FREQUENCY_MAP));
    }

    public FrequencyEncoding(StreamInput in) throws IOException {
        this.field = in.readString();
        this.featureName = in.readString();
        this.frequencyMap = Collections.unmodifiableMap(in.readMap(StreamInput::readString, StreamInput::readDouble));
    }

    public String getField() {
        return this.field;
    }

    public Map<String, Double> getFrequencyMap() {
        return this.frequencyMap;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public Map<String, String> reverseLookup() {
        return Collections.singletonMap(this.featureName, this.field);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public void process(Map<String, Object> fields) {
        Object value = fields.get(this.field);
        if (value == null) {
            return;
        }
        fields.put(this.featureName, this.frequencyMap.getOrDefault(value.toString(), 0.0));
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeString(this.featureName);
        out.writeMap(this.frequencyMap, StreamOutput::writeString, StreamOutput::writeDouble);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        builder.field(FEATURE_NAME.getPreferredName(), this.featureName);
        builder.field(FREQUENCY_MAP.getPreferredName(), this.frequencyMap);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequencyEncoding that = (FrequencyEncoding)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.frequencyMap, that.frequencyMap);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.featureName, this.frequencyMap);
    }

    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOf((String)this.field);
        size += RamUsageEstimator.sizeOf((String)this.featureName);
        return size += RamUsageEstimator.sizeOfMap(this.frequencyMap, (long)0L);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

