/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.AucRoc;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.ConfusionMatrix;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.Precision;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.Recall;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class BinarySoftClassification
implements Evaluation {
    public static final ParseField NAME = new ParseField("binary_soft_classification", new String[0]);
    private static final ParseField ACTUAL_FIELD = new ParseField("actual_field", new String[0]);
    private static final ParseField PREDICTED_PROBABILITY_FIELD = new ParseField("predicted_probability_field", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    public static final ConstructingObjectParser<BinarySoftClassification, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new BinarySoftClassification((String)a[0], (String)a[1], (List)a[2]));
    private final String actualField;
    private final String predictedProbabilityField;
    private final List<EvaluationMetric> metrics;

    public static BinarySoftClassification fromXContent(XContentParser parser) {
        return (BinarySoftClassification)PARSER.apply(parser, null);
    }

    static QueryBuilder actualIsTrueQuery(String actualField) {
        return QueryBuilders.queryStringQuery((String)(actualField + ": (1 OR true)"));
    }

    public BinarySoftClassification(String actualField, String predictedProbabilityField, @Nullable List<EvaluationMetric> metrics) {
        this.actualField = ExceptionsHelper.requireNonNull(actualField, ACTUAL_FIELD);
        this.predictedProbabilityField = ExceptionsHelper.requireNonNull(predictedProbabilityField, PREDICTED_PROBABILITY_FIELD);
        this.metrics = this.initMetrics(metrics, BinarySoftClassification::defaultMetrics);
    }

    private static List<EvaluationMetric> defaultMetrics() {
        return Arrays.asList(new AucRoc(false), new Precision(Arrays.asList(0.25, 0.5, 0.75)), new Recall(Arrays.asList(0.25, 0.5, 0.75)), new ConfusionMatrix(Arrays.asList(0.25, 0.5, 0.75)));
    }

    public BinarySoftClassification(StreamInput in) throws IOException {
        this.actualField = in.readString();
        this.predictedProbabilityField = in.readString();
        this.metrics = in.readNamedWriteableList(EvaluationMetric.class);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public String getActualField() {
        return this.actualField;
    }

    @Override
    public String getPredictedField() {
        return this.predictedProbabilityField;
    }

    public List<EvaluationMetric> getMetrics() {
        return this.metrics;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.actualField);
        out.writeString(this.predictedProbabilityField);
        out.writeNamedWriteableList(this.metrics);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTUAL_FIELD.getPreferredName(), this.actualField);
        builder.field(PREDICTED_PROBABILITY_FIELD.getPreferredName(), this.predictedProbabilityField);
        builder.startObject(METRICS.getPreferredName());
        for (EvaluationMetric metric : this.metrics) {
            builder.field(metric.getName(), (ToXContent)metric);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinarySoftClassification that = (BinarySoftClassification)o;
        return Objects.equals(this.actualField, that.actualField) && Objects.equals(this.predictedProbabilityField, that.predictedProbabilityField) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.actualField, this.predictedProbabilityField, this.metrics);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ACTUAL_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PREDICTED_PROBABILITY_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (EvaluationMetric)p.namedObject(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(NAME.getPreferredName(), n), c), METRICS);
    }
}

