/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.plugins.spi.NamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Accuracy;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Classification;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.MulticlassConfusionMatrix;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Recall;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.Huber;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.MeanSquaredError;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.MeanSquaredLogarithmicError;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.RSquared;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.Regression;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.AucRoc;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.BinarySoftClassification;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.ConfusionMatrix;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.Precision;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.ScoreByThresholdResult;

public class MlEvaluationNamedXContentProvider
implements NamedXContentProvider {
    public static String registeredMetricName(ParseField evaluationName, ParseField metricName) {
        return MlEvaluationNamedXContentProvider.registeredMetricName(evaluationName.getPreferredName(), metricName.getPreferredName());
    }

    public static String registeredMetricName(String evaluationName, String metricName) {
        return evaluationName + "." + metricName;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContentParsers() {
        return Arrays.asList(new NamedXContentRegistry.Entry(Evaluation.class, BinarySoftClassification.NAME, BinarySoftClassification::fromXContent), new NamedXContentRegistry.Entry(Evaluation.class, Classification.NAME, Classification::fromXContent), new NamedXContentRegistry.Entry(Evaluation.class, Regression.NAME, Regression::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, AucRoc.NAME), new String[0]), AucRoc::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, Precision.NAME), new String[0]), Precision::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.Recall.NAME), new String[0]), org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.Recall::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, ConfusionMatrix.NAME), new String[0]), ConfusionMatrix::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, MulticlassConfusionMatrix.NAME), new String[0]), MulticlassConfusionMatrix::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, Accuracy.NAME), new String[0]), Accuracy::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision.NAME), new String[0]), org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, Recall.NAME), new String[0]), Recall::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredError.NAME), new String[0]), MeanSquaredError::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredLogarithmicError.NAME), new String[0]), MeanSquaredLogarithmicError::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, Huber.NAME), new String[0]), Huber::fromXContent), new NamedXContentRegistry.Entry(EvaluationMetric.class, new ParseField(MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, RSquared.NAME), new String[0]), RSquared::fromXContent));
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(Evaluation.class, BinarySoftClassification.NAME.getPreferredName(), BinarySoftClassification::new), new NamedWriteableRegistry.Entry(Evaluation.class, Classification.NAME.getPreferredName(), Classification::new), new NamedWriteableRegistry.Entry(Evaluation.class, Regression.NAME.getPreferredName(), Regression::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, AucRoc.NAME), AucRoc::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, Precision.NAME), Precision::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.Recall.NAME), org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.Recall::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, ConfusionMatrix.NAME), ConfusionMatrix::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, MulticlassConfusionMatrix.NAME), MulticlassConfusionMatrix::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, Accuracy.NAME), Accuracy::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision.NAME), org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, Recall.NAME), Recall::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredError.NAME), MeanSquaredError::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredLogarithmicError.NAME), MeanSquaredLogarithmicError::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, Huber.NAME), Huber::new), new NamedWriteableRegistry.Entry(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, RSquared.NAME), RSquared::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, AucRoc.NAME), AucRoc.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, ScoreByThresholdResult.NAME), ScoreByThresholdResult::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(BinarySoftClassification.NAME, ConfusionMatrix.NAME), ConfusionMatrix.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, MulticlassConfusionMatrix.NAME), MulticlassConfusionMatrix.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, Accuracy.NAME), Accuracy.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision.NAME), Precision.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, Recall.NAME), Recall.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredError.NAME), MeanSquaredError.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, MeanSquaredLogarithmicError.NAME), MeanSquaredLogarithmicError.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, Huber.NAME), Huber.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, RSquared.NAME), RSquared.Result::new));
    }
}

