/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.BoostedTreeParams;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.FieldCardinalityConstraint;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.MapUtils;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Types;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Regression
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("regression", new String[0]);
    public static final ParseField DEPENDENT_VARIABLE = new ParseField("dependent_variable", new String[0]);
    public static final ParseField PREDICTION_FIELD_NAME = new ParseField("prediction_field_name", new String[0]);
    public static final ParseField TRAINING_PERCENT = new ParseField("training_percent", new String[0]);
    public static final ParseField RANDOMIZE_SEED = new ParseField("randomize_seed", new String[0]);
    public static final ParseField LOSS_FUNCTION = new ParseField("loss_function", new String[0]);
    public static final ParseField LOSS_FUNCTION_PARAMETER = new ParseField("loss_function_parameter", new String[0]);
    private static final String STATE_DOC_ID_SUFFIX = "_regression_state#1";
    private static final ConstructingObjectParser<Regression, Void> LENIENT_PARSER = Regression.createParser(true);
    private static final ConstructingObjectParser<Regression, Void> STRICT_PARSER = Regression.createParser(false);
    private static final List<String> PROGRESS_PHASES = Collections.unmodifiableList(Arrays.asList("feature_selection", "coarse_parameter_search", "fine_tuning_parameters", "final_training"));
    private final String dependentVariable;
    private final BoostedTreeParams boostedTreeParams;
    private final String predictionFieldName;
    private final double trainingPercent;
    private final long randomizeSeed;
    private final LossFunction lossFunction;
    private final Double lossFunctionParameter;

    private static ConstructingObjectParser<Regression, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new Regression((String)a[0], new BoostedTreeParams((Double)a[1], (Double)a[2], (Double)a[3], (Integer)a[4], (Double)a[5], (Integer)a[6]), (String)a[7], (Double)a[8], (Long)a[9], (LossFunction)((Object)((Object)a[10])), (Double)a[11]));
        parser.declareString(ConstructingObjectParser.constructorArg(), DEPENDENT_VARIABLE);
        BoostedTreeParams.declareFields(parser);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), PREDICTION_FIELD_NAME);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TRAINING_PERCENT);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), RANDOMIZE_SEED);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), x$0 -> LossFunction.fromString(x$0), LOSS_FUNCTION);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LOSS_FUNCTION_PARAMETER);
        return parser;
    }

    public static Regression fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return ignoreUnknownFields ? (Regression)LENIENT_PARSER.apply(parser, null) : (Regression)STRICT_PARSER.apply(parser, null);
    }

    public Regression(String dependentVariable, BoostedTreeParams boostedTreeParams, @Nullable String predictionFieldName, @Nullable Double trainingPercent, @Nullable Long randomizeSeed, @Nullable LossFunction lossFunction, @Nullable Double lossFunctionParameter) {
        if (trainingPercent != null && (trainingPercent < 1.0 || trainingPercent > 100.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in [1, 100]", TRAINING_PERCENT.getPreferredName());
        }
        this.dependentVariable = ExceptionsHelper.requireNonNull(dependentVariable, DEPENDENT_VARIABLE);
        this.boostedTreeParams = ExceptionsHelper.requireNonNull(boostedTreeParams, "boosted_tree_params");
        this.predictionFieldName = predictionFieldName == null ? dependentVariable + "_prediction" : predictionFieldName;
        this.trainingPercent = trainingPercent == null ? 100.0 : trainingPercent;
        this.randomizeSeed = randomizeSeed == null ? Randomness.get().nextLong() : randomizeSeed.longValue();
        LossFunction lossFunction2 = this.lossFunction = lossFunction == null ? LossFunction.MSE : lossFunction;
        if (lossFunctionParameter != null && lossFunctionParameter <= 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a positive double", LOSS_FUNCTION_PARAMETER.getPreferredName());
        }
        this.lossFunctionParameter = lossFunctionParameter;
    }

    public Regression(String dependentVariable) {
        this(dependentVariable, BoostedTreeParams.builder().build(), null, null, null, null, null);
    }

    public Regression(StreamInput in) throws IOException {
        this.dependentVariable = in.readString();
        this.boostedTreeParams = new BoostedTreeParams(in);
        this.predictionFieldName = in.readOptionalString();
        this.trainingPercent = in.readDouble();
        this.randomizeSeed = in.getVersion().onOrAfter(Version.V_7_6_0) ? in.readOptionalLong().longValue() : Randomness.get().nextLong();
        if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
            this.lossFunction = (LossFunction)in.readEnum(LossFunction.class);
            this.lossFunctionParameter = in.readOptionalDouble();
        } else {
            this.lossFunction = LossFunction.MSE;
            this.lossFunctionParameter = null;
        }
    }

    public String getDependentVariable() {
        return this.dependentVariable;
    }

    public BoostedTreeParams getBoostedTreeParams() {
        return this.boostedTreeParams;
    }

    public String getPredictionFieldName() {
        return this.predictionFieldName;
    }

    public double getTrainingPercent() {
        return this.trainingPercent;
    }

    public long getRandomizeSeed() {
        return this.randomizeSeed;
    }

    public LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public Double getLossFunctionParameter() {
        return this.lossFunctionParameter;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.dependentVariable);
        this.boostedTreeParams.writeTo(out);
        out.writeOptionalString(this.predictionFieldName);
        out.writeDouble(this.trainingPercent);
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeOptionalLong(Long.valueOf(this.randomizeSeed));
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeEnum((Enum)this.lossFunction);
            out.writeOptionalDouble(this.lossFunctionParameter);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Version version = Version.fromString((String)params.param("version", Version.CURRENT.toString()));
        builder.startObject();
        builder.field(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        this.boostedTreeParams.toXContent(builder, params);
        if (this.predictionFieldName != null) {
            builder.field(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        builder.field(TRAINING_PERCENT.getPreferredName(), this.trainingPercent);
        if (version.onOrAfter(Version.V_7_6_0)) {
            builder.field(RANDOMIZE_SEED.getPreferredName(), this.randomizeSeed);
        }
        builder.field(LOSS_FUNCTION.getPreferredName(), (Object)this.lossFunction);
        if (this.lossFunctionParameter != null) {
            builder.field(LOSS_FUNCTION_PARAMETER.getPreferredName(), this.lossFunctionParameter);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public Map<String, Object> getParams(DataFrameAnalysis.FieldInfo fieldInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        params.putAll(this.boostedTreeParams.getParams());
        if (this.predictionFieldName != null) {
            params.put(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        params.put(TRAINING_PERCENT.getPreferredName(), this.trainingPercent);
        params.put(LOSS_FUNCTION.getPreferredName(), this.lossFunction.toString());
        if (this.lossFunctionParameter != null) {
            params.put(LOSS_FUNCTION_PARAMETER.getPreferredName(), this.lossFunctionParameter);
        }
        return params;
    }

    @Override
    public boolean supportsCategoricalFields() {
        return true;
    }

    @Override
    public Set<String> getAllowedCategoricalTypes(String fieldName) {
        return Types.categorical();
    }

    @Override
    public List<RequiredField> getRequiredFields() {
        return Collections.singletonList(new RequiredField(this.dependentVariable, Types.numerical()));
    }

    @Override
    public List<FieldCardinalityConstraint> getFieldCardinalityConstraints() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getExplicitlyMappedFields(Map<String, Object> mappingsProperties, String resultsFieldName) {
        HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
        additionalProperties.put(resultsFieldName + ".feature_importance", MapUtils.featureImportanceMapping());
        additionalProperties.put(resultsFieldName + "." + this.predictionFieldName, Collections.singletonMap("type", NumberFieldMapper.NumberType.DOUBLE.typeName()));
        return additionalProperties;
    }

    @Override
    public boolean supportsMissingValues() {
        return true;
    }

    @Override
    public boolean persistsState() {
        return true;
    }

    @Override
    public String getStateDocId(String jobId) {
        return jobId + STATE_DOC_ID_SUFFIX;
    }

    @Override
    public List<String> getProgressPhases() {
        return PROGRESS_PHASES;
    }

    @Override
    public InferenceConfig inferenceConfig(DataFrameAnalysis.FieldInfo fieldInfo) {
        return RegressionConfig.builder().setResultsField(this.predictionFieldName).setNumTopFeatureImportanceValues(this.getBoostedTreeParams().getNumTopFeatureImportanceValues()).build();
    }

    @Override
    public boolean supportsInference() {
        return true;
    }

    public static String extractJobIdFromStateDoc(String stateDocId) {
        int suffixIndex = stateDocId.lastIndexOf(STATE_DOC_ID_SUFFIX);
        return suffixIndex <= 0 ? null : stateDocId.substring(0, suffixIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Regression that = (Regression)o;
        return Objects.equals(this.dependentVariable, that.dependentVariable) && Objects.equals(this.boostedTreeParams, that.boostedTreeParams) && Objects.equals(this.predictionFieldName, that.predictionFieldName) && this.trainingPercent == that.trainingPercent && this.randomizeSeed == that.randomizeSeed && this.lossFunction == that.lossFunction && Objects.equals(this.lossFunctionParameter, that.lossFunctionParameter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dependentVariable, this.boostedTreeParams, this.predictionFieldName, this.trainingPercent, this.randomizeSeed, this.lossFunction, this.lossFunctionParameter});
    }

    public static enum LossFunction {
        MSE,
        MSLE,
        HUBER;


        private static LossFunction fromString(String value) {
            return LossFunction.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

