/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class MachineLearningFeatureSetUsage
extends XPackFeatureSet.Usage {
    public static final String ALL = "_all";
    public static final String JOBS_FIELD = "jobs";
    public static final String DATAFEEDS_FIELD = "datafeeds";
    public static final String COUNT = "count";
    public static final String DETECTORS = "detectors";
    public static final String FORECASTS = "forecasts";
    public static final String MODEL_SIZE = "model_size";
    public static final String CREATED_BY = "created_by";
    public static final String NODE_COUNT = "node_count";
    public static final String DATA_FRAME_ANALYTICS_JOBS_FIELD = "data_frame_analytics_jobs";
    public static final String INFERENCE_FIELD = "inference";
    private final Map<String, Object> jobsUsage;
    private final Map<String, Object> datafeedsUsage;
    private final Map<String, Object> analyticsUsage;
    private final Map<String, Object> inferenceUsage;
    private final int nodeCount;

    public MachineLearningFeatureSetUsage(boolean available, boolean enabled, Map<String, Object> jobsUsage, Map<String, Object> datafeedsUsage, Map<String, Object> analyticsUsage, Map<String, Object> inferenceUsage, int nodeCount) {
        super("ml", available, enabled);
        this.jobsUsage = Objects.requireNonNull(jobsUsage);
        this.datafeedsUsage = Objects.requireNonNull(datafeedsUsage);
        this.analyticsUsage = Objects.requireNonNull(analyticsUsage);
        this.inferenceUsage = Objects.requireNonNull(inferenceUsage);
        this.nodeCount = nodeCount;
    }

    public MachineLearningFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.jobsUsage = in.readMap();
        this.datafeedsUsage = in.readMap();
        this.analyticsUsage = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readMap() : Collections.emptyMap();
        this.inferenceUsage = in.getVersion().onOrAfter(Version.V_7_6_0) ? in.readMap() : Collections.emptyMap();
        this.nodeCount = in.getVersion().onOrAfter(Version.V_6_5_0) ? in.readInt() : -1;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_0_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.jobsUsage);
        out.writeMap(this.datafeedsUsage);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeMap(this.analyticsUsage);
        }
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeMap(this.inferenceUsage);
        }
        if (out.getVersion().onOrAfter(Version.V_6_5_0)) {
            out.writeInt(this.nodeCount);
        }
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field(JOBS_FIELD, this.jobsUsage);
        builder.field(DATAFEEDS_FIELD, this.datafeedsUsage);
        builder.field(DATA_FRAME_ANALYTICS_JOBS_FIELD, this.analyticsUsage);
        builder.field(INFERENCE_FIELD, this.inferenceUsage);
        if (this.nodeCount >= 0) {
            builder.field(NODE_COUNT, this.nodeCount);
        }
    }
}

