/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;

final class WaitForFollowShardTasksStep
extends AsyncWaitStep {
    static final String NAME = "wait-for-follow-shard-tasks";

    WaitForFollowShardTasksStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public void evaluateCondition(Metadata metadata, Index index, AsyncWaitStep.Listener listener, TimeValue masterTimeout) {
        IndexMetadata indexMetadata = metadata.index(index);
        Map customIndexMetadata = indexMetadata.getCustomData("ccr");
        if (customIndexMetadata == null) {
            listener.onResponse(true, null);
            return;
        }
        FollowStatsAction.StatsRequest request = new FollowStatsAction.StatsRequest();
        request.setIndices(new String[]{index.getName()});
        this.getClient().execute((ActionType)FollowStatsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> this.handleResponse((FollowStatsAction.StatsResponses)((Object)r), listener), listener::onFailure));
    }

    void handleResponse(FollowStatsAction.StatsResponses responses, AsyncWaitStep.Listener listener) {
        boolean conditionMet;
        List unSyncedShardFollowStatuses = responses.getStatsResponses().stream().map(FollowStatsAction.StatsResponse::status).filter(shardFollowStatus -> shardFollowStatus.leaderGlobalCheckpoint() != shardFollowStatus.followerGlobalCheckpoint()).collect(Collectors.toList());
        boolean bl = conditionMet = responses.getStatsResponses().size() > 0 && unSyncedShardFollowStatuses.isEmpty();
        if (conditionMet) {
            listener.onResponse(true, null);
        } else {
            List<Info.ShardFollowTaskInfo> shardFollowTaskInfos = unSyncedShardFollowStatuses.stream().map(status -> new Info.ShardFollowTaskInfo(status.followerIndex(), status.getShardId(), status.leaderGlobalCheckpoint(), status.followerGlobalCheckpoint())).collect(Collectors.toList());
            listener.onResponse(false, new Info(shardFollowTaskInfos));
        }
    }

    static final class Info
    implements ToXContentObject {
        static final ParseField SHARD_FOLLOW_TASKS = new ParseField("shard_follow_tasks", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);
        private final List<ShardFollowTaskInfo> shardFollowTaskInfos;

        Info(List<ShardFollowTaskInfo> shardFollowTaskInfos) {
            this.shardFollowTaskInfos = shardFollowTaskInfos;
        }

        List<ShardFollowTaskInfo> getShardFollowTaskInfos() {
            return this.shardFollowTaskInfos;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SHARD_FOLLOW_TASKS.getPreferredName(), this.shardFollowTaskInfos);
            String message = this.shardFollowTaskInfos.size() > 0 ? "Waiting for [" + this.shardFollowTaskInfos.size() + "] shard follow tasks to be in sync" : "Waiting for following to be unpaused and all shard follow tasks to be up to date";
            builder.field(MESSAGE.getPreferredName(), message);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return Objects.equals(this.shardFollowTaskInfos, info.shardFollowTaskInfos);
        }

        public int hashCode() {
            return Objects.hash(this.shardFollowTaskInfos);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static final class ShardFollowTaskInfo
        implements ToXContentObject {
            static final ParseField FOLLOWER_INDEX_FIELD = new ParseField("follower_index", new String[0]);
            static final ParseField SHARD_ID_FIELD = new ParseField("shard_id", new String[0]);
            static final ParseField LEADER_GLOBAL_CHECKPOINT_FIELD = new ParseField("leader_global_checkpoint", new String[0]);
            static final ParseField FOLLOWER_GLOBAL_CHECKPOINT_FIELD = new ParseField("follower_global_checkpoint", new String[0]);
            private final String followerIndex;
            private final int shardId;
            private final long leaderGlobalCheckpoint;
            private final long followerGlobalCheckpoint;

            ShardFollowTaskInfo(String followerIndex, int shardId, long leaderGlobalCheckpoint, long followerGlobalCheckpoint) {
                this.followerIndex = followerIndex;
                this.shardId = shardId;
                this.leaderGlobalCheckpoint = leaderGlobalCheckpoint;
                this.followerGlobalCheckpoint = followerGlobalCheckpoint;
            }

            String getFollowerIndex() {
                return this.followerIndex;
            }

            int getShardId() {
                return this.shardId;
            }

            long getLeaderGlobalCheckpoint() {
                return this.leaderGlobalCheckpoint;
            }

            long getFollowerGlobalCheckpoint() {
                return this.followerGlobalCheckpoint;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(FOLLOWER_INDEX_FIELD.getPreferredName(), this.followerIndex);
                builder.field(SHARD_ID_FIELD.getPreferredName(), this.shardId);
                builder.field(LEADER_GLOBAL_CHECKPOINT_FIELD.getPreferredName(), this.leaderGlobalCheckpoint);
                builder.field(FOLLOWER_GLOBAL_CHECKPOINT_FIELD.getPreferredName(), this.followerGlobalCheckpoint);
                builder.endObject();
                return builder;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ShardFollowTaskInfo that = (ShardFollowTaskInfo)o;
                return this.shardId == that.shardId && this.leaderGlobalCheckpoint == that.leaderGlobalCheckpoint && this.followerGlobalCheckpoint == that.followerGlobalCheckpoint && Objects.equals(this.followerIndex, that.followerIndex);
            }

            public int hashCode() {
                return Objects.hash(this.followerIndex, this.shardId, this.leaderGlobalCheckpoint, this.followerGlobalCheckpoint);
            }
        }
    }
}

