/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.xpack.core.ccr.action.UnfollowAction;
import org.elasticsearch.xpack.core.ilm.AbstractUnfollowIndexStep;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

final class UnfollowFollowIndexStep
extends AbstractUnfollowIndexStep {
    private static final Logger logger = LogManager.getLogger(UnfollowFollowIndexStep.class);
    static final String NAME = "unfollow-follower-index";

    UnfollowFollowIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    void innerPerformAction(String followerIndex, AsyncActionStep.Listener listener) {
        UnfollowAction.Request request = new UnfollowAction.Request(followerIndex);
        this.getClient().execute((ActionType)UnfollowAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
            assert (r.isAcknowledged()) : "unfollow response is not acknowledged";
            listener.onResponse(true);
        }, exception -> {
            if (exception instanceof ElasticsearchException && ((ElasticsearchException)exception).getMetadata("es.failed_to_remove_retention_leases") != null) {
                List leasesNotRemoved = ((ElasticsearchException)exception).getMetadata("es.failed_to_remove_retention_leases");
                logger.debug("failed to remove leader retention lease(s) {} while unfollowing index [{}], continuing with lifecycle execution", (Object)leasesNotRemoved, (Object)followerIndex);
                listener.onResponse(true);
            } else {
                listener.onFailure((Exception)exception);
            }
        }));
    }
}

