/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.CloseIndexStep;
import org.elasticsearch.xpack.core.ilm.ForceMergeStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.OpenIndexStep;
import org.elasticsearch.xpack.core.ilm.SegmentCountStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.UpdateSettingsStep;
import org.elasticsearch.xpack.core.ilm.WaitForIndexColorStep;

public class ForceMergeAction
implements LifecycleAction {
    public static final String NAME = "forcemerge";
    public static final ParseField MAX_NUM_SEGMENTS_FIELD = new ParseField("max_num_segments", new String[0]);
    public static final ParseField CODEC = new ParseField("index_codec", new String[0]);
    private static final ConstructingObjectParser<ForceMergeAction, Void> PARSER = new ConstructingObjectParser("forcemerge", false, a -> {
        int maxNumSegments = (Integer)a[0];
        String codec = a[1] != null ? (String)a[1] : null;
        return new ForceMergeAction(maxNumSegments, codec);
    });
    private final int maxNumSegments;
    private final String codec;

    public static ForceMergeAction parse(XContentParser parser) {
        return (ForceMergeAction)PARSER.apply(parser, null);
    }

    public ForceMergeAction(int maxNumSegments, @Nullable String codec) {
        if (maxNumSegments <= 0) {
            throw new IllegalArgumentException("[" + MAX_NUM_SEGMENTS_FIELD.getPreferredName() + "] must be a positive integer");
        }
        this.maxNumSegments = maxNumSegments;
        if (codec != null && !"best_compression".equals(codec)) {
            throw new IllegalArgumentException("unknown index codec: [" + codec + "]");
        }
        this.codec = codec;
    }

    public ForceMergeAction(StreamInput in) throws IOException {
        this.maxNumSegments = in.readVInt();
        this.codec = in.getVersion().onOrAfter(Version.V_7_7_0) ? in.readOptionalString() : null;
    }

    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    public String getCodec() {
        return this.codec;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.maxNumSegments);
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeOptionalString(this.codec);
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MAX_NUM_SEGMENTS_FIELD.getPreferredName(), this.maxNumSegments);
        if (this.codec != null) {
            builder.field(CODEC.getPreferredName(), this.codec);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Settings readOnlySettings = Settings.builder().put(IndexMetadata.SETTING_BLOCKS_WRITE, true).build();
        Settings bestCompressionSettings = Settings.builder().put(EngineConfig.INDEX_CODEC_SETTING.getKey(), "best_compression").build();
        boolean codecChange = this.codec != null && this.codec.equals("best_compression");
        Step.StepKey checkNotWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey readOnlyKey = new Step.StepKey(phase, NAME, "readonly");
        Step.StepKey closeKey = new Step.StepKey(phase, NAME, "close-index");
        Step.StepKey updateCompressionKey = new Step.StepKey(phase, NAME, "update-settings");
        Step.StepKey openKey = new Step.StepKey(phase, NAME, "open-index");
        Step.StepKey waitForGreenIndexKey = new Step.StepKey(phase, NAME, "wait-for-index-color");
        Step.StepKey forceMergeKey = new Step.StepKey(phase, NAME, NAME);
        Step.StepKey countKey = new Step.StepKey(phase, NAME, "segment-count");
        CheckNotDataStreamWriteIndexStep checkNotWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNotWriteIndex, readOnlyKey);
        UpdateSettingsStep readOnlyStep = new UpdateSettingsStep(readOnlyKey, codecChange ? closeKey : forceMergeKey, client, readOnlySettings);
        CloseIndexStep closeIndexStep = new CloseIndexStep(closeKey, updateCompressionKey, client);
        UpdateSettingsStep updateBestCompressionSettings = new UpdateSettingsStep(updateCompressionKey, openKey, client, bestCompressionSettings);
        OpenIndexStep openIndexStep = new OpenIndexStep(openKey, waitForGreenIndexKey, client);
        WaitForIndexColorStep waitForIndexGreenStep = new WaitForIndexColorStep(waitForGreenIndexKey, forceMergeKey, ClusterHealthStatus.GREEN);
        ForceMergeStep forceMergeStep = new ForceMergeStep(forceMergeKey, countKey, client, this.maxNumSegments);
        SegmentCountStep segmentCountStep = new SegmentCountStep(countKey, nextStepKey, client, this.maxNumSegments);
        ArrayList<Step> mergeSteps = new ArrayList<Step>();
        mergeSteps.add(checkNotWriteIndexStep);
        mergeSteps.add(readOnlyStep);
        if (codecChange) {
            mergeSteps.add(closeIndexStep);
            mergeSteps.add(updateBestCompressionSettings);
            mergeSteps.add(openIndexStep);
            mergeSteps.add(waitForIndexGreenStep);
        }
        mergeSteps.add(forceMergeStep);
        mergeSteps.add(segmentCountStep);
        return mergeSteps;
    }

    public int hashCode() {
        return Objects.hash(this.maxNumSegments, this.codec);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ForceMergeAction other = (ForceMergeAction)obj;
        return Objects.equals(this.maxNumSegments, other.maxNumSegments) && Objects.equals(this.codec, other.codec);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), MAX_NUM_SEGMENTS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CODEC);
    }
}

