/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class EnrichFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;

    @Inject
    public EnrichFeatureSet(@Nullable XPackLicenseState licenseState) {
        this.licenseState = licenseState;
    }

    @Override
    public String name() {
        return "enrich";
    }

    @Override
    public boolean available() {
        return this.licenseState.isAllowed(XPackLicenseState.Feature.ENRICH);
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    @Override
    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        listener.onResponse((Object)new Usage(this.available(), this.enabled()));
    }

    public static class Usage
    extends XPackFeatureSet.Usage {
        Usage(boolean available, boolean enabled) {
            super("enrich", available, enabled);
        }

        public Usage(StreamInput input) throws IOException {
            super(input);
        }

        public Version getMinimalSupportedVersion() {
            return Version.V_7_5_0;
        }
    }
}

