/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncTask;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.DeleteAsyncResultRequest;

public class DeleteAsyncResultsService {
    private final Logger logger = LogManager.getLogger(DeleteAsyncResultsService.class);
    private final TaskManager taskManager;
    private final AsyncTaskIndexService<? extends AsyncResponse<?>> store;

    public DeleteAsyncResultsService(AsyncTaskIndexService<? extends AsyncResponse<?>> store, TaskManager taskManager) {
        this.taskManager = taskManager;
        this.store = store;
    }

    public void deleteResult(DeleteAsyncResultRequest request, ActionListener<AcknowledgedResponse> listener) {
        try {
            AsyncExecutionId searchId = AsyncExecutionId.decode(request.getId());
            AsyncTask task = this.store.getTask(this.taskManager, searchId, AsyncTask.class);
            if (task != null) {
                task.cancelTask(this.taskManager, () -> this.store.deleteResponse(searchId, (ActionListener<DeleteResponse>)ActionListener.wrap(r -> listener.onResponse((Object)new AcknowledgedResponse(true)), exc -> {
                    RestStatus status = ExceptionsHelper.status((Throwable)ExceptionsHelper.unwrapCause((Throwable)exc));
                    if (status == RestStatus.NOT_FOUND) {
                        listener.onResponse((Object)new AcknowledgedResponse(true));
                    } else {
                        this.logger.error(() -> new ParameterizedMessage("failed to clean async result [{}]", (Object)searchId.getEncoded()), (Throwable)exc);
                        listener.onFailure(exc);
                    }
                })), "cancelled by user");
            } else {
                ActionListener deleteListener = ActionListener.wrap(resp -> {
                    if (resp.status() == RestStatus.NOT_FOUND) {
                        listener.onFailure((Exception)new ResourceNotFoundException(searchId.getEncoded(), new Object[0]));
                    } else {
                        listener.onResponse((Object)new AcknowledgedResponse(true));
                    }
                }, exc -> {
                    this.logger.error(() -> new ParameterizedMessage("failed to clean async-search [{}]", (Object)searchId.getEncoded()), (Throwable)exc);
                    listener.onFailure(exc);
                });
                this.store.authorizeResponse(searchId, false, ActionListener.wrap(res -> this.store.deleteResponse(searchId, (ActionListener<DeleteResponse>)deleteListener), arg_0 -> listener.onFailure(arg_0)));
            }
        }
        catch (Exception exc2) {
            listener.onFailure(exc2);
        }
    }
}

