/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.action.util.QueryPage;

public abstract class AbstractGetResourcesResponse<T extends ToXContent & Writeable>
extends ActionResponse
implements StatusToXContentObject {
    private QueryPage<T> resources;

    protected AbstractGetResourcesResponse() {
    }

    protected AbstractGetResourcesResponse(StreamInput in) throws IOException {
        super(in);
        this.resources = new QueryPage<T>(in, this.getReader());
    }

    protected AbstractGetResourcesResponse(QueryPage<T> resources) {
        this.resources = Objects.requireNonNull(resources);
    }

    public QueryPage<T> getResources() {
        return this.resources;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.resources.writeTo(out);
    }

    public RestStatus status() {
        return RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.resources.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.resources);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractGetResourcesResponse)) {
            return false;
        }
        AbstractGetResourcesResponse other = (AbstractGetResourcesResponse)((Object)obj);
        return Objects.equals(this.resources, other.resources);
    }

    public final String toString() {
        return Strings.toString((ToXContent)this);
    }

    protected abstract Writeable.Reader<T> getReader();
}

