/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.PostStartBasicResponse;
import org.elasticsearch.protocol.xpack.license.DeleteLicenseRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteLicenseAction
extends TransportMasterNodeAction<DeleteLicenseRequest, AcknowledgedResponse> {
    private final LicenseService licenseService;

    @Inject
    public TransportDeleteLicenseAction(TransportService transportService, ClusterService clusterService, LicenseService licenseService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/license/delete", transportService, clusterService, threadPool, actionFilters, DeleteLicenseRequest::new, indexNameExpressionResolver);
        this.licenseService = licenseService;
    }

    protected String executor() {
        return "management";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(DeleteLicenseRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(DeleteLicenseRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws ElasticsearchException {
        this.licenseService.removeLicense(request, new ActionListener<PostStartBasicResponse>(){

            public void onResponse(PostStartBasicResponse postStartBasicResponse) {
                listener.onResponse((Object)new AcknowledgedResponse(postStartBasicResponse.isAcknowledged()));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

