/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.License;

public class PutLicenseRequest
extends AcknowledgedRequest<PutLicenseRequest> {
    private License license;
    private boolean acknowledge = false;

    public PutLicenseRequest(StreamInput in) throws IOException {
        super(in);
        this.license = License.readLicense(in);
        this.acknowledge = in.readBoolean();
    }

    public PutLicenseRequest() {
    }

    public ActionRequestValidationException validate() {
        return this.license == null ? ValidateActions.addValidationError((String)"license is missing", null) : null;
    }

    public PutLicenseRequest license(BytesReference licenseDefinition, XContentType xContentType) {
        try {
            return this.license(License.fromSource(licenseDefinition, xContentType));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed to parse license source", e);
        }
    }

    public PutLicenseRequest license(License license) {
        this.license = license;
        return this;
    }

    public License license() {
        return this.license;
    }

    public PutLicenseRequest acknowledge(boolean acknowledge) {
        this.acknowledge = acknowledge;
        return this;
    }

    public boolean acknowledged() {
        return this.acknowledge;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.license.writeTo(out);
        out.writeBoolean(this.acknowledge);
    }
}

