/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.decision;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecision;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecisionType;

public class AutoscalingDecisions
implements ToXContent,
Writeable {
    private final Collection<AutoscalingDecision> decisions;

    public Collection<AutoscalingDecision> decisions() {
        return this.decisions;
    }

    public AutoscalingDecisions(Collection<AutoscalingDecision> decisions) {
        Objects.requireNonNull(decisions);
        if (decisions.isEmpty()) {
            throw new IllegalArgumentException("decisions can not be empty");
        }
        this.decisions = decisions;
    }

    public AutoscalingDecisions(StreamInput in) throws IOException {
        this.decisions = in.readList(AutoscalingDecision::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.decisions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (AutoscalingDecision decision : this.decisions) {
            decision.toXContent(builder, params);
        }
        return builder;
    }

    public AutoscalingDecisionType type() {
        if (this.decisions.stream().anyMatch(p -> p.type() == AutoscalingDecisionType.SCALE_UP)) {
            return AutoscalingDecisionType.SCALE_UP;
        }
        if (this.decisions.stream().allMatch(p -> p.type() == AutoscalingDecisionType.SCALE_DOWN)) {
            return AutoscalingDecisionType.SCALE_DOWN;
        }
        return AutoscalingDecisionType.NO_SCALE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingDecisions that = (AutoscalingDecisions)o;
        return this.decisions.equals(that.decisions);
    }

    public int hashCode() {
        return Objects.hash(this.decisions);
    }
}

