/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.decision;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public enum AutoscalingDecisionType implements Writeable,
ToXContentFragment
{
    SCALE_DOWN(0),
    NO_SCALE(1),
    SCALE_UP(2);

    private final byte id;

    byte id() {
        return this.id;
    }

    private AutoscalingDecisionType(byte id) {
        this.id = id;
    }

    public static AutoscalingDecisionType readFrom(StreamInput in) throws IOException {
        byte id = in.readByte();
        switch (id) {
            case 0: {
                return SCALE_DOWN;
            }
            case 1: {
                return NO_SCALE;
            }
            case 2: {
                return SCALE_UP;
            }
        }
        throw new IllegalArgumentException("unexpected value [" + id + "] for autoscaling decision type");
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.value(this.name().toLowerCase(Locale.ROOT));
        return builder;
    }
}

