/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.decision;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecisionType;

public class AutoscalingDecision
implements ToXContent,
Writeable {
    private final String name;
    private final AutoscalingDecisionType type;
    private final String reason;

    public String name() {
        return this.name;
    }

    public AutoscalingDecisionType type() {
        return this.type;
    }

    public String reason() {
        return this.reason;
    }

    public AutoscalingDecision(String name, AutoscalingDecisionType type, String reason) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.reason = Objects.requireNonNull(reason);
    }

    public AutoscalingDecision(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = AutoscalingDecisionType.readFrom(in);
        this.reason = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        this.type.writeTo(out);
        out.writeString(this.reason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("type", (ToXContent)this.type);
        builder.field("reason", this.reason);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingDecision that = (AutoscalingDecision)o;
        return this.name.equals(that.name) && this.type == that.type && this.reason.equals(that.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.reason});
    }
}

