/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecisions;

public class GetAutoscalingDecisionAction
extends ActionType<Response> {
    public static final GetAutoscalingDecisionAction INSTANCE = new GetAutoscalingDecisionAction();
    public static final String NAME = "cluster:admin/autoscaling/get_autoscaling_decision";

    private GetAutoscalingDecisionAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final SortedMap<String, AutoscalingDecisions> decisions;

        public Response(SortedMap<String, AutoscalingDecisions> decisions) {
            this.decisions = Objects.requireNonNull(decisions);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.decisions = new TreeMap<String, AutoscalingDecisions>(in.readMap(StreamInput::readString, AutoscalingDecisions::new));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.decisions, StreamOutput::writeString, (o, decision) -> decision.writeTo(o));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("decisions");
            for (Map.Entry<String, AutoscalingDecisions> decision : this.decisions.entrySet()) {
                builder.startObject();
                builder.field(decision.getKey(), (ToXContent)decision.getValue());
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.decisions.equals(response.decisions);
        }

        public int hashCode() {
            return Objects.hash(this.decisions);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && ((Object)((Object)this)).getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }
    }
}

