/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class UpdateRequest
extends InstanceShardOperationRequest<UpdateRequest>
implements DocWriteRequest<UpdateRequest>,
WriteRequest<UpdateRequest>,
ToXContentObject {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(UpdateRequest.class);
    private static ObjectParser<UpdateRequest, Void> PARSER;
    private static final ParseField SCRIPT_FIELD;
    private static final ParseField SCRIPTED_UPSERT_FIELD;
    private static final ParseField UPSERT_FIELD;
    private static final ParseField DOC_FIELD;
    private static final ParseField DOC_AS_UPSERT_FIELD;
    private static final ParseField DETECT_NOOP_FIELD;
    private static final ParseField SOURCE_FIELD;
    private static final ParseField IF_SEQ_NO;
    private static final ParseField IF_PRIMARY_TERM;
    private String type;
    private String id;
    @Nullable
    private String routing;
    @Nullable
    Script script;
    private FetchSourceContext fetchSourceContext;
    private int retryOnConflict = 0;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.NONE;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private IndexRequest upsertRequest;
    private boolean scriptedUpsert = false;
    private boolean docAsUpsert = false;
    private boolean detectNoop = true;
    @Nullable
    private IndexRequest doc;

    public UpdateRequest() {
    }

    public UpdateRequest(StreamInput in) throws IOException {
        this(null, in);
    }

    public UpdateRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
        String[] fields;
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        if (in.getVersion().before(Version.V_7_0_0)) {
            in.readOptionalString();
        }
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        this.retryOnConflict = in.readVInt();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
        if (in.readBoolean()) {
            this.doc = new IndexRequest(shardId, in);
        }
        if (in.getVersion().before(Version.V_7_0_0) && (fields = in.readOptionalStringArray()) != null) {
            throw new IllegalArgumentException("[fields] is no longer supported");
        }
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::new);
        if (in.readBoolean()) {
            this.upsertRequest = new IndexRequest(shardId, in);
        }
        this.docAsUpsert = in.readBoolean();
        if (in.getVersion().before(Version.V_7_0_0)) {
            long version = in.readLong();
            VersionType versionType = VersionType.readFromStream(in);
            if (version != -3L || versionType != VersionType.INTERNAL) {
                throw new UnsupportedOperationException("versioned update requests have been removed in 7.0. Use if_seq_no and if_primary_term");
            }
        }
        this.ifSeqNo = in.readZLong();
        this.ifPrimaryTerm = in.readVLong();
        this.detectNoop = in.readBoolean();
        this.scriptedUpsert = in.readBoolean();
    }

    public UpdateRequest(String index, String id) {
        super(index);
        this.id = id;
    }

    @Deprecated
    public UpdateRequest(String index, String type, String id) {
        super(index);
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.upsertRequest != null && this.upsertRequest.version() != -3L) {
            validationException = ValidateActions.addValidationError("can't provide version in upsert request", validationException);
        }
        if (Strings.isEmpty(this.type())) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (Strings.isEmpty(this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams(this, validationException);
        if (this.ifSeqNo != -2L) {
            if (this.retryOnConflict > 0) {
                validationException = ValidateActions.addValidationError("compare and write operations can not be retried", validationException);
            }
            if (this.docAsUpsert) {
                validationException = ValidateActions.addValidationError("compare and write operations can not be used with upsert", validationException);
            }
            if (this.upsertRequest != null) {
                validationException = ValidateActions.addValidationError("upsert requests don't support `if_seq_no` and `if_primary_term`", validationException);
            }
        }
        if (this.script == null && this.doc == null) {
            validationException = ValidateActions.addValidationError("script or doc is missing", validationException);
        }
        if (this.script != null && this.doc != null) {
            validationException = ValidateActions.addValidationError("can't provide both script and doc", validationException);
        }
        if (this.doc == null && this.docAsUpsert) {
            validationException = ValidateActions.addValidationError("doc must be specified if doc_as_upsert is enabled", validationException);
        }
        return validationException;
    }

    @Override
    @Deprecated
    public String type() {
        if (this.type == null) {
            return "_doc";
        }
        return this.type;
    }

    @Override
    @Deprecated
    public UpdateRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Deprecated
    public UpdateRequest defaultTypeIfNull(String defaultType) {
        if (Strings.isNullOrEmpty(this.type)) {
            this.type = defaultType;
        }
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public UpdateRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public UpdateRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Script script() {
        return this.script;
    }

    public UpdateRequest script(Script script) {
        this.script = script;
        return this;
    }

    @Deprecated
    public String scriptString() {
        return this.script == null ? null : this.script.getIdOrCode();
    }

    @Deprecated
    public ScriptType scriptType() {
        return this.script == null ? null : this.script.getType();
    }

    @Deprecated
    public Map<String, Object> scriptParams() {
        return this.script == null ? null : this.script.getParams();
    }

    @Deprecated
    public UpdateRequest script(String script, ScriptType scriptType) {
        this.updateOrCreateScript(script, scriptType, null, null);
        return this;
    }

    @Deprecated
    public UpdateRequest script(String script) {
        this.updateOrCreateScript(script, ScriptType.INLINE, null, null);
        return this;
    }

    @Deprecated
    public UpdateRequest scriptLang(String scriptLang) {
        this.updateOrCreateScript(null, null, scriptLang, null);
        return this;
    }

    @Deprecated
    public String scriptLang() {
        return this.script == null ? null : this.script.getLang();
    }

    @Deprecated
    public UpdateRequest addScriptParam(String name, Object value) {
        Script script = this.script();
        if (script == null) {
            HashMap<String, Object> scriptParams = new HashMap<String, Object>();
            scriptParams.put(name, value);
            this.updateOrCreateScript(null, null, null, scriptParams);
        } else {
            Map<String, Object> scriptParams = script.getParams();
            if (scriptParams == null) {
                scriptParams = new HashMap<String, Object>();
                scriptParams.put(name, value);
                this.updateOrCreateScript(null, null, null, scriptParams);
            } else {
                scriptParams.put(name, value);
            }
        }
        return this;
    }

    @Deprecated
    public UpdateRequest scriptParams(Map<String, Object> scriptParams) {
        this.updateOrCreateScript(null, null, null, scriptParams);
        return this;
    }

    private void updateOrCreateScript(String scriptContent, ScriptType type, String lang, Map<String, Object> params) {
        Script script = this.script();
        if (script == null) {
            script = new Script(type == null ? ScriptType.INLINE : type, lang, scriptContent == null ? "" : scriptContent, params);
        } else {
            String newScriptContent = scriptContent == null ? script.getIdOrCode() : scriptContent;
            ScriptType newScriptType = type == null ? script.getType() : type;
            String newScriptLang = lang == null ? script.getLang() : lang;
            Map<String, Object> newScriptParams = params == null ? script.getParams() : params;
            script = new Script(newScriptType, newScriptLang, newScriptContent, newScriptParams);
        }
        this.script(script);
    }

    @Deprecated
    public UpdateRequest script(String script, ScriptType scriptType, @Nullable Map<String, Object> scriptParams) {
        this.script = new Script(scriptType, "painless", script, scriptParams);
        return this;
    }

    @Deprecated
    public UpdateRequest script(String script, @Nullable String scriptLang, ScriptType scriptType, @Nullable Map<String, Object> scriptParams) {
        this.script = new Script(scriptType, scriptLang, script, scriptParams);
        return this;
    }

    public UpdateRequest fetchSource(@Nullable String include, @Nullable String exclude) {
        String[] stringArray;
        String[] stringArray2;
        FetchSourceContext context;
        FetchSourceContext fetchSourceContext = context = this.fetchSourceContext == null ? FetchSourceContext.FETCH_SOURCE : this.fetchSourceContext;
        if (include == null) {
            stringArray2 = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        String[] includes = stringArray2;
        if (exclude == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        String[] excludes = stringArray;
        this.fetchSourceContext = new FetchSourceContext(context.fetchSource(), includes, excludes);
        return this;
    }

    public UpdateRequest fetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        FetchSourceContext context = this.fetchSourceContext == null ? FetchSourceContext.FETCH_SOURCE : this.fetchSourceContext;
        this.fetchSourceContext = new FetchSourceContext(context.fetchSource(), includes, excludes);
        return this;
    }

    public UpdateRequest fetchSource(boolean fetchSource) {
        FetchSourceContext context = this.fetchSourceContext == null ? FetchSourceContext.FETCH_SOURCE : this.fetchSourceContext;
        this.fetchSourceContext = new FetchSourceContext(fetchSource, context.includes(), context.excludes());
        return this;
    }

    public UpdateRequest fetchSource(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    public FetchSourceContext fetchSource() {
        return this.fetchSourceContext;
    }

    public UpdateRequest retryOnConflict(int retryOnConflict) {
        this.retryOnConflict = retryOnConflict;
        return this;
    }

    public int retryOnConflict() {
        return this.retryOnConflict;
    }

    @Override
    public UpdateRequest version(long version) {
        throw new UnsupportedOperationException("update requests do not support versioning");
    }

    @Override
    public long version() {
        return -3L;
    }

    @Override
    public UpdateRequest versionType(VersionType versionType) {
        throw new UnsupportedOperationException("update requests do not support versioning");
    }

    @Override
    public VersionType versionType() {
        return VersionType.INTERNAL;
    }

    @Override
    public UpdateRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    @Override
    public UpdateRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    @Override
    public long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Override
    public long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return DocWriteRequest.OpType.UPDATE;
    }

    @Override
    public UpdateRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public UpdateRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public UpdateRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public UpdateRequest doc(IndexRequest doc) {
        this.doc = doc;
        return this;
    }

    public UpdateRequest doc(XContentBuilder source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(Map<String, Object> source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(Map<String, Object> source, XContentType contentType) {
        this.safeDoc().source(source, contentType);
        return this;
    }

    public UpdateRequest doc(String source, XContentType xContentType) {
        this.safeDoc().source(source, xContentType);
        return this;
    }

    public UpdateRequest doc(byte[] source, XContentType xContentType) {
        this.safeDoc().source(source, xContentType);
        return this;
    }

    public UpdateRequest doc(byte[] source, int offset, int length, XContentType xContentType) {
        this.safeDoc().source(source, offset, length, xContentType);
        return this;
    }

    public UpdateRequest doc(Object ... source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(XContentType xContentType, Object ... source) {
        this.safeDoc().source(xContentType, source);
        return this;
    }

    public IndexRequest doc() {
        return this.doc;
    }

    private IndexRequest safeDoc() {
        if (this.doc == null) {
            this.doc = new IndexRequest();
        }
        return this.doc;
    }

    public UpdateRequest upsert(IndexRequest upsertRequest) {
        this.upsertRequest = upsertRequest;
        return this;
    }

    public UpdateRequest upsert(XContentBuilder source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(Map<String, Object> source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(Map<String, Object> source, XContentType contentType) {
        this.safeUpsertRequest().source(source, contentType);
        return this;
    }

    public UpdateRequest upsert(String source, XContentType xContentType) {
        this.safeUpsertRequest().source(source, xContentType);
        return this;
    }

    public UpdateRequest upsert(byte[] source, XContentType xContentType) {
        this.safeUpsertRequest().source(source, xContentType);
        return this;
    }

    public UpdateRequest upsert(byte[] source, int offset, int length, XContentType xContentType) {
        this.safeUpsertRequest().source(source, offset, length, xContentType);
        return this;
    }

    public UpdateRequest upsert(Object ... source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(XContentType xContentType, Object ... source) {
        this.safeUpsertRequest().source(xContentType, source);
        return this;
    }

    public IndexRequest upsertRequest() {
        return this.upsertRequest;
    }

    private IndexRequest safeUpsertRequest() {
        if (this.upsertRequest == null) {
            this.upsertRequest = new IndexRequest();
        }
        return this.upsertRequest;
    }

    public UpdateRequest detectNoop(boolean detectNoop) {
        this.detectNoop = detectNoop;
        return this;
    }

    public boolean detectNoop() {
        return this.detectNoop;
    }

    public UpdateRequest fromXContent(XContentParser parser) throws IOException {
        return (UpdateRequest)PARSER.parse(parser, (Object)this, null);
    }

    public boolean docAsUpsert() {
        return this.docAsUpsert;
    }

    public UpdateRequest docAsUpsert(boolean shouldUpsertDoc) {
        this.docAsUpsert = shouldUpsertDoc;
        return this;
    }

    public boolean scriptedUpsert() {
        return this.scriptedUpsert;
    }

    public UpdateRequest scriptedUpsert(boolean scriptedUpsert) {
        this.scriptedUpsert = scriptedUpsert;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.doWrite(out, false);
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        super.writeThin(out);
        this.doWrite(out, true);
    }

    private void doWrite(StreamOutput out, boolean thin) throws IOException {
        this.waitForActiveShards.writeTo(out);
        out.writeString(this.type());
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalString(null);
        }
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        out.writeVInt(this.retryOnConflict);
        this.refreshPolicy.writeTo(out);
        if (this.doc == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.doc.index(this.index);
            this.doc.type(this.type);
            this.doc.id(this.id);
            if (thin) {
                this.doc.writeThin(out);
            } else {
                this.doc.writeTo(out);
            }
        }
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalStringArray(null);
        }
        out.writeOptionalWriteable(this.fetchSourceContext);
        if (this.upsertRequest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.upsertRequest.index(this.index);
            this.upsertRequest.type(this.type);
            this.upsertRequest.id(this.id);
            if (thin) {
                this.upsertRequest.writeThin(out);
            } else {
                this.upsertRequest.writeTo(out);
            }
        }
        out.writeBoolean(this.docAsUpsert);
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeLong(-3L);
            out.writeByte(VersionType.INTERNAL.getValue());
        }
        out.writeZLong(this.ifSeqNo);
        out.writeVLong(this.ifPrimaryTerm);
        out.writeBoolean(this.detectNoop);
        out.writeBoolean(this.scriptedUpsert);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentParser parser;
        XContentType xContentType;
        builder.startObject();
        if (this.docAsUpsert) {
            builder.field("doc_as_upsert", this.docAsUpsert);
        }
        if (this.doc != null) {
            xContentType = this.doc.getContentType();
            parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, this.doc.source(), xContentType);
            try {
                builder.field("doc");
                builder.copyCurrentStructure(parser);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        if (this.ifSeqNo != -2L) {
            builder.field(IF_SEQ_NO.getPreferredName(), this.ifSeqNo);
            builder.field(IF_PRIMARY_TERM.getPreferredName(), this.ifPrimaryTerm);
        }
        if (this.script != null) {
            builder.field("script", (ToXContent)this.script);
        }
        if (this.upsertRequest != null) {
            xContentType = this.upsertRequest.getContentType();
            parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, this.upsertRequest.source(), xContentType);
            try {
                builder.field("upsert");
                builder.copyCurrentStructure(parser);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        if (this.scriptedUpsert) {
            builder.field("scripted_upsert", this.scriptedUpsert);
        }
        if (!this.detectNoop) {
            builder.field("detect_noop", this.detectNoop);
        }
        if (this.fetchSourceContext != null) {
            builder.field("_source", (ToXContent)this.fetchSourceContext);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        StringBuilder res = new StringBuilder().append("update {[").append(this.index).append("][").append(this.type()).append("][").append(this.id).append("]");
        res.append(", doc_as_upsert[").append(this.docAsUpsert).append("]");
        if (this.doc != null) {
            res.append(", doc[").append(this.doc).append("]");
        }
        if (this.script != null) {
            res.append(", script[").append(this.script).append("]");
        }
        if (this.upsertRequest != null) {
            res.append(", upsert[").append(this.upsertRequest).append("]");
        }
        res.append(", scripted_upsert[").append(this.scriptedUpsert).append("]");
        res.append(", detect_noop[").append(this.detectNoop).append("]");
        return res.append("}").toString();
    }

    public long ramBytesUsed() {
        long childRequestBytes = 0L;
        if (this.doc != null) {
            childRequestBytes += this.doc.ramBytesUsed();
        }
        if (this.upsertRequest != null) {
            childRequestBytes += this.upsertRequest.ramBytesUsed();
        }
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.id) + childRequestBytes;
    }

    static {
        SCRIPT_FIELD = new ParseField("script", new String[0]);
        SCRIPTED_UPSERT_FIELD = new ParseField("scripted_upsert", new String[0]);
        UPSERT_FIELD = new ParseField("upsert", new String[0]);
        DOC_FIELD = new ParseField("doc", new String[0]);
        DOC_AS_UPSERT_FIELD = new ParseField("doc_as_upsert", new String[0]);
        DETECT_NOOP_FIELD = new ParseField("detect_noop", new String[0]);
        SOURCE_FIELD = new ParseField("_source", new String[0]);
        IF_SEQ_NO = new ParseField("if_seq_no", new String[0]);
        IF_PRIMARY_TERM = new ParseField("if_primary_term", new String[0]);
        PARSER = new ObjectParser(UpdateRequest.class.getSimpleName());
        PARSER.declareField((request, script) -> {
            request.script = script;
        }, (parser, context) -> Script.parse(parser), SCRIPT_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareBoolean(UpdateRequest::scriptedUpsert, SCRIPTED_UPSERT_FIELD);
        PARSER.declareObject((request, builder) -> request.safeUpsertRequest().source((XContentBuilder)builder), (parser, context) -> {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)parser.contentType());
            builder.copyCurrentStructure(parser);
            return builder;
        }, UPSERT_FIELD);
        PARSER.declareObject((request, builder) -> request.safeDoc().source((XContentBuilder)builder), (parser, context) -> {
            XContentBuilder docBuilder = XContentFactory.contentBuilder((XContentType)parser.contentType());
            docBuilder.copyCurrentStructure(parser);
            return docBuilder;
        }, DOC_FIELD);
        PARSER.declareBoolean(UpdateRequest::docAsUpsert, DOC_AS_UPSERT_FIELD);
        PARSER.declareBoolean(UpdateRequest::detectNoop, DETECT_NOOP_FIELD);
        PARSER.declareField(UpdateRequest::fetchSource, (parser, context) -> FetchSourceContext.fromXContent(parser), SOURCE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
        PARSER.declareLong(UpdateRequest::setIfSeqNo, IF_SEQ_NO);
        PARSER.declareLong(UpdateRequest::setIfPrimaryTerm, IF_PRIMARY_TERM);
    }
}

