/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.ql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.ql.tree.Source;

public class WildcardQuery
extends LeafQuery {
    private final String field;
    private final String query;

    public WildcardQuery(Source source, String field, String query) {
        super(source);
        this.field = field;
        this.query = query;
    }

    public String field() {
        return this.field;
    }

    public String query() {
        return this.query;
    }

    @Override
    public QueryBuilder asBuilder() {
        return QueryBuilders.wildcardQuery((String)this.field, (String)this.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardQuery other = (WildcardQuery)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.query, other.query);
    }

    @Override
    protected String innerToString() {
        return this.field + ":" + this.query;
    }
}

