/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class OrderBy
extends UnaryPlan {
    private final List<Order> order;

    public OrderBy(Source source, LogicalPlan child, List<Order> order) {
        super(source, child);
        this.order = order;
    }

    @Override
    protected NodeInfo<OrderBy> info() {
        return NodeInfo.create(this, OrderBy::new, this.child(), this.order);
    }

    @Override
    protected OrderBy replaceChild(LogicalPlan newChild) {
        return new OrderBy(this.source(), newChild, this.order);
    }

    public List<Order> order() {
        return this.order;
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.order);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.order, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.child(), other.child());
    }
}

