/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.ql.capabilities.Resolvable;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class Pipe
extends Node<Pipe>
implements FieldExtraction,
Resolvable {
    private final Expression expression;

    public Pipe(Source source, Expression expression, List<Pipe> children) {
        super(source, children);
        this.expression = expression;
    }

    public Expression expression() {
        return this.expression;
    }

    @Override
    public boolean resolved() {
        return Resolvables.resolved(this.children());
    }

    @Override
    public void collectFields(QlSourceBuilder sourceBuilder) {
        this.children().forEach(c -> c.collectFields(sourceBuilder));
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.children().stream().anyMatch(Pipe::supportedByAggsOnlyQuery);
    }

    public abstract Processor asProcessor();

    public Pipe resolveAttributes(AttributeResolver resolver) {
        ArrayList<Pipe> newPipes = new ArrayList<Pipe>(this.children().size());
        for (Pipe p : this.children()) {
            newPipes.add(p.resolveAttributes(resolver));
        }
        return this.children().equals(newPipes) ? this : (Pipe)this.replaceChildren(newPipes);
    }

    public static interface AttributeResolver {
        public FieldExtraction resolve(Attribute var1);
    }
}

