/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.NamedExpression;

public class AttributeMap<E>
implements Map<Attribute, E> {
    public static final AttributeMap EMPTY = new AttributeMap();
    private final Map<AttributeWrapper, E> delegate;
    private Set<Attribute> keySet = null;
    private Collection<E> values = null;
    private Set<Map.Entry<Attribute, E>> entrySet = null;

    public static final <E> AttributeMap<E> emptyAttributeMap() {
        return EMPTY;
    }

    public AttributeMap() {
        this.delegate = new LinkedHashMap<AttributeWrapper, E>();
    }

    public AttributeMap(Map<Attribute, E> attr) {
        if (attr.isEmpty()) {
            this.delegate = Collections.emptyMap();
        } else {
            this.delegate = new LinkedHashMap<AttributeWrapper, E>(attr.size());
            for (Map.Entry<Attribute, E> entry : attr.entrySet()) {
                this.delegate.put(new AttributeWrapper(entry.getKey()), entry.getValue());
            }
        }
    }

    public AttributeMap(Attribute key, E value) {
        this.delegate = Collections.singletonMap(new AttributeWrapper(key), value);
    }

    void add(Attribute key, E value) {
        this.delegate.put(new AttributeWrapper(key), value);
    }

    void addAll(AttributeMap<E> other) {
        this.delegate.putAll(other.delegate);
    }

    public AttributeMap<E> combine(AttributeMap<E> other) {
        AttributeMap<E> combine = new AttributeMap<E>();
        combine.addAll(this);
        combine.addAll(other);
        return combine;
    }

    public AttributeMap<E> subtract(AttributeMap<E> other) {
        AttributeMap<E> diff = new AttributeMap<E>();
        for (Map.Entry<AttributeWrapper, E> entry : this.delegate.entrySet()) {
            if (other.delegate.containsKey(entry.getKey())) continue;
            diff.delegate.put(entry.getKey(), entry.getValue());
        }
        return diff;
    }

    public AttributeMap<E> intersect(AttributeMap<E> other) {
        AttributeMap<E> smaller = other.size() > this.size() ? this : other;
        AttributeMap<E> larger = smaller == this ? other : this;
        AttributeMap<E> intersect = new AttributeMap<E>();
        for (Map.Entry<AttributeWrapper, E> entry : smaller.delegate.entrySet()) {
            if (!larger.delegate.containsKey(entry.getKey())) continue;
            intersect.delegate.put(entry.getKey(), entry.getValue());
        }
        return intersect;
    }

    public boolean subsetOf(AttributeMap<E> other) {
        if (this.size() > other.size()) {
            return false;
        }
        for (AttributeWrapper aw : this.delegate.keySet()) {
            if (other.delegate.containsKey(aw)) continue;
            return false;
        }
        return true;
    }

    public Set<String> attributeNames() {
        LinkedHashSet<String> s = new LinkedHashSet<String>(this.size());
        for (AttributeWrapper aw : this.delegate.keySet()) {
            s.add(aw.attr.name());
        }
        return s;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof NamedExpression) {
            return this.delegate.keySet().contains(new AttributeWrapper(((NamedExpression)key).toAttribute()));
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.values().contains(value);
    }

    @Override
    public E get(Object key) {
        if (key instanceof NamedExpression) {
            return this.delegate.get(new AttributeWrapper(((NamedExpression)key).toAttribute()));
        }
        return null;
    }

    @Override
    public E getOrDefault(Object key, E defaultValue) {
        E e = this.get(key);
        return e != null || this.containsKey(key) ? e : defaultValue;
    }

    @Override
    public E put(Attribute key, E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Attribute, ? extends E> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Attribute> keySet() {
        if (this.keySet == null) {
            this.keySet = new UnwrappingSet<AttributeWrapper, Attribute>(this.delegate.keySet()){

                @Override
                protected Attribute unwrap(AttributeWrapper next) {
                    return next.attr;
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<E> values() {
        if (this.values == null) {
            this.values = Collections.unmodifiableCollection(this.delegate.values());
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Attribute, E>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new UnwrappingSet<Map.Entry<AttributeWrapper, E>, Map.Entry<Attribute, E>>(this.delegate.entrySet()){

                @Override
                protected Map.Entry<Attribute, E> unwrap(final Map.Entry<AttributeWrapper, E> next) {
                    return new Map.Entry<Attribute, E>(){

                        @Override
                        public Attribute getKey() {
                            return ((AttributeWrapper)next.getKey()).attr;
                        }

                        @Override
                        public E getValue() {
                            return next.getValue();
                        }

                        @Override
                        public E setValue(E value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public void forEach(BiConsumer<? super Attribute, ? super E> action) {
        this.delegate.forEach((? super K k, ? super V v) -> action.accept(((AttributeWrapper)k).attr, (Object)v));
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AttributeMap) {
            obj = ((AttributeMap)obj).delegate;
        }
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }

    static class AttributeWrapper {
        private final Attribute attr;

        AttributeWrapper(Attribute attr) {
            this.attr = attr;
        }

        public int hashCode() {
            return this.attr.semanticHash();
        }

        public boolean equals(Object obj) {
            if (obj instanceof AttributeWrapper) {
                AttributeWrapper aw = (AttributeWrapper)obj;
                return this.attr.semanticEquals(aw.attr);
            }
            return false;
        }

        public String toString() {
            return this.attr.toString();
        }
    }

    private static abstract class UnwrappingSet<W, U>
    extends AbstractSet<U> {
        private final Set<W> set;

        UnwrappingSet(Set<W> originalSet) {
            this.set = Collections.unmodifiableSet(originalSet);
        }

        @Override
        public Iterator<U> iterator() {
            return new Iterator<U>(){
                final Iterator<W> i;
                {
                    this.i = set.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public U next() {
                    return this.unwrap(this.i.next());
                }
            };
        }

        protected abstract U unwrap(W var1);

        @Override
        public Stream<U> stream() {
            return this.set.stream().map(this::unwrap);
        }

        @Override
        public Stream<U> parallelStream() {
            return this.set.parallelStream().map(this::unwrap);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean equals(Object o) {
            return this.set.equals(o);
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }

        @Override
        public Object[] toArray() {
            Object[] array = this.set.toArray();
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((AttributeWrapper)array[i]).attr;
            }
            return array;
        }

        @Override
        public <A> A[] toArray(A[] a) {
            if (a.length < this.size()) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
            }
            int i = 0;
            A[] result = a;
            for (U u : this) {
                result[i++] = u;
            }
            if (a.length > this.size()) {
                a[this.size()] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            return this.set.toString();
        }
    }
}

