/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.MultiGeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoHashGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

public class BoundedGeoHashGridTiler
extends GeoHashGridTiler {
    private final double boundsTop;
    private final double boundsBottom;
    private final double boundsWestLeft;
    private final double boundsWestRight;
    private final double boundsEastLeft;
    private final double boundsEastRight;
    private final boolean crossesDateline;

    public BoundedGeoHashGridTiler(GeoBoundingBox geoBoundingBox) {
        this.boundsTop = geoBoundingBox.top();
        this.boundsBottom = geoBoundingBox.bottom();
        if (geoBoundingBox.right() < geoBoundingBox.left()) {
            this.boundsWestLeft = -180.0;
            this.boundsWestRight = geoBoundingBox.right();
            this.boundsEastLeft = geoBoundingBox.left();
            this.boundsEastRight = 180.0;
            this.crossesDateline = true;
        } else {
            this.boundsEastLeft = geoBoundingBox.left();
            this.boundsEastRight = geoBoundingBox.right();
            this.boundsWestLeft = 0.0;
            this.boundsWestRight = 0.0;
            this.crossesDateline = false;
        }
    }

    boolean cellIntersectsGeoBoundingBox(Rectangle rectangle) {
        return this.boundsTop >= rectangle.getMinY() && this.boundsBottom <= rectangle.getMaxY() && (this.boundsEastLeft <= rectangle.getMaxX() && this.boundsEastRight >= rectangle.getMinX() || this.crossesDateline && this.boundsWestLeft <= rectangle.getMaxX() && this.boundsWestRight >= rectangle.getMinX());
    }

    @Override
    protected int setValue(GeoShapeCellValues docValues, MultiGeoShapeValues.GeoShapeValue geoValue, MultiGeoShapeValues.BoundingBox bounds, int precision) {
        String hash = Geohash.stringEncode((double)bounds.minX(), (double)bounds.minY(), (int)precision);
        GeoRelation relation = this.relateTile(geoValue, hash);
        if (relation != GeoRelation.QUERY_DISJOINT) {
            docValues.resizeCell(1);
            docValues.add(0, Geohash.longEncode((String)hash));
            return 1;
        }
        return 0;
    }

    @Override
    protected GeoRelation relateTile(MultiGeoShapeValues.GeoShapeValue geoValue, String hash) {
        Rectangle rectangle = Geohash.toBoundingBox((String)hash);
        if (this.cellIntersectsGeoBoundingBox(rectangle)) {
            return geoValue.relate(rectangle);
        }
        return GeoRelation.QUERY_DISJOINT;
    }

    @Override
    protected int setValuesForFullyContainedTile(String hash, GeoShapeCellValues values, int valuesIndex, int targetPrecision) {
        String[] hashes = Geohash.getSubGeohashes((String)hash);
        for (int i = 0; i < hashes.length; ++i) {
            if (hashes[i].length() == targetPrecision) {
                if (!this.cellIntersectsGeoBoundingBox(Geohash.toBoundingBox((String)hashes[i]))) continue;
                values.add(valuesIndex++, Geohash.longEncode((String)hashes[i]));
                continue;
            }
            valuesIndex = this.setValuesForFullyContainedTile(hashes[i], values, valuesIndex, targetPrecision);
        }
        return valuesIndex;
    }
}

