/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.query;

import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.xpack.spatial.common.ShapeUtils;
import org.elasticsearch.xpack.spatial.index.mapper.PointFieldMapper;

public class ShapeQueryPointProcessor
implements AbstractGeometryFieldMapper.AbstractGeometryFieldType.QueryProcessor {
    public Query process(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        this.validateIsPointFieldType(fieldName, context);
        if (relation != ShapeRelation.INTERSECTS) {
            throw new QueryShardException(context, relation + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private void validateIsPointFieldType(String fieldName, QueryShardContext context) {
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        if (!(fieldType instanceof PointFieldMapper.PointFieldType)) {
            throw new QueryShardException(context, "Expected point field type for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
    }

    protected Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        ShapeVisitor shapeVisitor = new ShapeVisitor(context, fieldName, relation);
        return (Query)queryShape.visit((GeometryVisitor)shapeVisitor);
    }

    private class ShapeVisitor
    implements GeometryVisitor<Query, RuntimeException> {
        QueryShardContext context;
        MappedFieldType fieldType;
        String fieldName;
        ShapeRelation relation;

        ShapeVisitor(QueryShardContext context, String fieldName, ShapeRelation relation) {
            this.context = context;
            this.fieldType = context.fieldMapper(fieldName);
            this.fieldName = fieldName;
            this.relation = relation;
        }

        public Query visit(Circle circle) {
            XYCircle xyCircle = ShapeUtils.toLuceneXYCircle(circle);
            Query query = XYPointField.newDistanceQuery((String)this.fieldName, (float)xyCircle.getX(), (float)xyCircle.getY(), (float)xyCircle.getRadius());
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = XYDocValuesField.newSlowDistanceQuery((String)this.fieldName, (float)xyCircle.getX(), (float)xyCircle.getY(), (float)xyCircle.getRadius());
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        public Query visit(GeometryCollection<?> collection) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            this.visit(bqb, collection);
            return bqb.build();
        }

        private void visit(BooleanQuery.Builder bqb, GeometryCollection<?> collection) {
            BooleanClause.Occur occur = BooleanClause.Occur.FILTER;
            for (Geometry shape : collection) {
                bqb.add((Query)shape.visit((GeometryVisitor)this), occur);
            }
        }

        public Query visit(Line line) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + ShapeType.LINESTRING + " queries", new Object[0]);
        }

        public Query visit(LinearRing ring) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + ShapeType.LINEARRING + " queries", new Object[0]);
        }

        public Query visit(MultiLine multiLine) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + ShapeType.MULTILINESTRING + " queries", new Object[0]);
        }

        public Query visit(MultiPoint multiPoint) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + ShapeType.MULTIPOINT + " queries", new Object[0]);
        }

        public Query visit(MultiPolygon multiPolygon) {
            XYPolygon[] lucenePolygons = new XYPolygon[multiPolygon.size()];
            for (int i = 0; i < multiPolygon.size(); ++i) {
                lucenePolygons[i] = ShapeUtils.toLuceneXYPolygon((Polygon)multiPolygon.get(i));
            }
            Query query = XYPointField.newPolygonQuery((String)this.fieldName, (XYPolygon[])lucenePolygons);
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = XYDocValuesField.newSlowPolygonQuery((String)this.fieldName, (XYPolygon[])lucenePolygons);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        public Query visit(Point point) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + ShapeType.POINT + " queries", new Object[0]);
        }

        public Query visit(Polygon polygon) {
            XYPolygon lucenePolygon = ShapeUtils.toLuceneXYPolygon(polygon);
            Query query = XYPointField.newPolygonQuery((String)this.fieldName, (XYPolygon[])new XYPolygon[]{lucenePolygon});
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = XYDocValuesField.newSlowPolygonQuery((String)this.fieldName, (XYPolygon[])new XYPolygon[]{lucenePolygon});
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        public Query visit(Rectangle r) {
            XYRectangle xyRectangle = ShapeUtils.toLuceneXYRectangle(r);
            Query query = XYPointField.newBoxQuery((String)this.fieldName, (float)xyRectangle.minX, (float)xyRectangle.maxX, (float)xyRectangle.minY, (float)xyRectangle.maxY);
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = XYDocValuesField.newSlowBoxQuery((String)this.fieldName, (float)xyRectangle.minX, (float)xyRectangle.maxX, (float)xyRectangle.minY, (float)xyRectangle.maxY);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }
    }
}

