/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractGeometryQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class ShapeQueryBuilder
extends AbstractGeometryQueryBuilder<ShapeQueryBuilder> {
    public static final String NAME = "shape";
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(GeoShapeQueryBuilder.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [geo_shape] queries. The type should no longer be specified in the [indexed_shape] section.";
    protected static final List<String> validContentTypes = Collections.unmodifiableList(Arrays.asList("shape", "point"));

    @Deprecated
    protected ShapeQueryBuilder(String fieldName, ShapeBuilder shape) {
        super(fieldName, shape);
    }

    public ShapeQueryBuilder(String fieldName, Geometry shape) {
        super(fieldName, shape);
    }

    protected ShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId, @Nullable String indexedShapeType) {
        super(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
    }

    public ShapeQueryBuilder(String fieldName, String indexedShapeId) {
        super(fieldName, indexedShapeId);
    }

    @Deprecated
    protected ShapeQueryBuilder(String fieldName, String indexedShapeId, String indexedShapeType) {
        super(fieldName, (Geometry)null, indexedShapeId, indexedShapeType);
    }

    public ShapeQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
    }

    protected ShapeQueryBuilder newShapeQueryBuilder(String fieldName, Geometry shape) {
        return new ShapeQueryBuilder(fieldName, shape);
    }

    protected ShapeQueryBuilder newShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId, String indexedShapeType) {
        return new ShapeQueryBuilder(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
    }

    protected List<String> validContentTypes() {
        return validContentTypes;
    }

    public Query buildShapeQuery(QueryShardContext context, MappedFieldType fieldType) {
        List<String> validContentTypes = this.validContentTypes();
        if (!validContentTypes.contains(fieldType.typeName())) {
            throw new QueryShardException(context, "Field [" + this.fieldName + "] is not of type [" + String.join((CharSequence)" or ", this.validContentTypes()) + "] but of type [" + fieldType.typeName() + "]", new Object[0]);
        }
        AbstractGeometryFieldMapper.AbstractGeometryFieldType ft = (AbstractGeometryFieldMapper.AbstractGeometryFieldType)fieldType;
        return new ConstantScoreQuery(ft.geometryQueryBuilder().process(this.shape, ft.name(), this.relation, context));
    }

    public void doShapeQueryXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    protected ShapeQueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        return (ShapeQueryBuilder)super.doRewrite(queryRewriteContext);
    }

    protected boolean doEquals(ShapeQueryBuilder other) {
        return super.doEquals((AbstractGeometryQueryBuilder)other);
    }

    protected int doHashCode() {
        return Objects.hash(super.doHashCode());
    }

    public String getWriteableName() {
        return NAME;
    }

    public static ShapeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        ParsedShapeQueryParams pgsqb = (ParsedShapeQueryParams)AbstractGeometryQueryBuilder.parsedParamsFromXContent((XContentParser)parser, (AbstractGeometryQueryBuilder.ParsedGeometryQueryParams)new ParsedShapeQueryParams());
        if (pgsqb.type != null) {
            deprecationLogger.deprecatedAndMaybeLog("geo_share_query_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        ShapeQueryBuilder builder = pgsqb.shape != null ? new ShapeQueryBuilder(pgsqb.fieldName, pgsqb.shape) : new ShapeQueryBuilder(pgsqb.fieldName, pgsqb.id, pgsqb.type);
        if (pgsqb.index != null) {
            builder.indexedShapeIndex(pgsqb.index);
        }
        if (pgsqb.shapePath != null) {
            builder.indexedShapePath(pgsqb.shapePath);
        }
        if (pgsqb.shapeRouting != null) {
            builder.indexedShapeRouting(pgsqb.shapeRouting);
        }
        if (pgsqb.relation != null) {
            builder.relation(pgsqb.relation);
        }
        if (pgsqb.queryName != null) {
            builder.queryName(pgsqb.queryName);
        }
        builder.boost(pgsqb.boost);
        builder.ignoreUnmapped(pgsqb.ignoreUnmapped);
        return builder;
    }

    private static class ParsedShapeQueryParams
    extends AbstractGeometryQueryBuilder.ParsedGeometryQueryParams {
        private ParsedShapeQueryParams() {
        }

        protected boolean parseXContentField(XContentParser parser) throws IOException {
            if (SHAPE_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                this.shape = ShapeParser.parse((XContentParser)parser);
                return true;
            }
            return false;
        }
    }
}

