/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeIndexer;
import org.elasticsearch.xpack.spatial.index.query.ShapeQueryProcessor;

public class ShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry, Geometry> {
    public static final String CONTENT_TYPE = "shape";

    public ShapeFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<ShapeBuilder.Orientation> orientation, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, ignoreMalformed, coerce, ignoreZValue, orientation, multiFields, copyTo);
    }

    protected void mergeGeoOptions(AbstractShapeGeometryFieldMapper<?, ?> mergeWith, List<String> conflicts) {
    }

    protected void addStoredFields(ParseContext context, Geometry geometry) {
    }

    protected void addDocValuesFields(String name, Geometry geometry, List fields, ParseContext context) {
    }

    protected void addMultiFields(ParseContext context, Geometry geometry) {
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public ShapeFieldType fieldType() {
        return (ShapeFieldType)super.fieldType();
    }

    public static final class ShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType {
        public ShapeFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, hasDocValues, meta);
        }

        public String typeName() {
            return ShapeFieldMapper.CONTENT_TYPE;
        }

        protected AbstractGeometryFieldMapper.Indexer<Geometry, Geometry> geometryIndexer() {
            return this.geometryIndexer;
        }
    }

    public static class TypeParser
    extends AbstractShapeGeometryFieldMapper.TypeParser {
        protected boolean parseXContentParameters(String name, Map.Entry<String, Object> entry, Map<String, Object> params) throws MapperParsingException {
            return false;
        }

        public Builder newBuilder(String name, Map<String, Object> params) {
            return new Builder(name);
        }
    }

    public static class Builder
    extends AbstractShapeGeometryFieldMapper.Builder<Builder, ShapeFieldType> {
        public Builder(String name) {
            super(name, new FieldType());
            this.fieldType.setDimensions(7, 4, 4);
            this.builder = this;
        }

        public ShapeFieldMapper build(Mapper.BuilderContext context) {
            ShapeFieldType ft = new ShapeFieldType(this.buildFullName(context), this.indexed, this.hasDocValues, this.meta);
            GeometryParser geometryParser = new GeometryParser(((ShapeBuilder.Orientation)this.orientation().value()).getAsBoolean(), ((Boolean)this.coerce().value()).booleanValue(), ((Boolean)this.ignoreZValue().value()).booleanValue());
            ft.setGeometryParser((parser, mapper) -> geometryParser.parse(parser));
            ft.setGeometryIndexer(new ShapeIndexer(ft.name()));
            ft.setGeometryQueryBuilder(new ShapeQueryProcessor());
            ft.setOrientation((ShapeBuilder.Orientation)this.orientation().value());
            return new ShapeFieldMapper(this.name, this.fieldType, (MappedFieldType)ft, (Explicit<Boolean>)this.ignoreMalformed(context), (Explicit<Boolean>)this.coerce(context), (Explicit<Boolean>)this.ignoreZValue(), (Explicit<ShapeBuilder.Orientation>)this.orientation(), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo);
        }
    }
}

