/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.index.query.ShapeQueryPointProcessor;

public class PointFieldMapper
extends AbstractPointGeometryFieldMapper<List<? extends CartesianPoint>, List<? extends CartesianPoint>> {
    public static final String CONTENT_TYPE = "point";

    protected AbstractPointGeometryFieldMapper.ParsedPoint newParsedPoint() {
        return new ParsedCartesianPoint();
    }

    protected void parsePointIgnoringMalformed(XContentParser parser, AbstractPointGeometryFieldMapper.ParsedPoint point) throws IOException {
        super.parsePointIgnoringMalformed(parser, point);
        CartesianPoint.parsePoint(parser, (CartesianPoint)point, (boolean)((Boolean)this.ignoreZValue().value()));
    }

    public PointFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, AbstractPointGeometryFieldMapper.ParsedPoint nullValue, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, ignoreMalformed, ignoreZValue, nullValue, copyTo);
    }

    protected void addStoredFields(ParseContext context, List<? extends CartesianPoint> points) {
        for (CartesianPoint cartesianPoint : points) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), cartesianPoint.toString()));
        }
    }

    protected void addDocValuesFields(String name, List<? extends CartesianPoint> points, List<IndexableField> fields, ParseContext context) {
        for (CartesianPoint cartesianPoint : points) {
            context.doc().add((IndexableField)new XYDocValuesField(this.fieldType().name(), cartesianPoint.getX(), cartesianPoint.getY()));
        }
    }

    protected void addMultiFields(ParseContext context, List<? extends CartesianPoint> points) {
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public PointFieldType fieldType() {
        return (PointFieldType)this.mappedFieldType;
    }

    protected static class ParsedCartesianPoint
    extends CartesianPoint
    implements AbstractPointGeometryFieldMapper.ParsedPoint {
        protected ParsedCartesianPoint() {
        }

        public void validate(String fieldName) {
            if (!Float.isFinite(this.getX())) {
                throw new IllegalArgumentException("illegal x value [" + this.getX() + "] for " + fieldName);
            }
            if (!Float.isFinite(this.getY())) {
                throw new IllegalArgumentException("illegal y value [" + this.getY() + "] for " + fieldName);
            }
        }

        public void normalize(String fieldName) {
        }

        public boolean isNormalizable(double coord) {
            return false;
        }

        public void resetCoords(double x, double y) {
            this.reset((float)x, (float)y);
        }

        @Override
        public boolean equals(Object other) {
            double oY;
            double oX;
            if (other instanceof CartesianPoint) {
                CartesianPoint o = (CartesianPoint)other;
                oX = o.getX();
                oY = o.getY();
            } else {
                if (!(other instanceof ParsedCartesianPoint)) {
                    return false;
                }
                ParsedCartesianPoint o = (ParsedCartesianPoint)other;
                oX = o.getX();
                oY = o.getY();
            }
            if (Double.compare(oX, this.x) != 0) {
                return false;
            }
            return Double.compare(oY, this.y) == 0;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class PointFieldType
    extends AbstractPointGeometryFieldMapper.AbstractPointGeometryFieldType<List<ParsedCartesianPoint>, List<ParsedCartesianPoint>> {
        public PointFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, hasDocValues, meta);
        }

        public String typeName() {
            return PointFieldMapper.CONTENT_TYPE;
        }
    }

    protected static class PointIndexer
    implements AbstractGeometryFieldMapper.Indexer<List<ParsedCartesianPoint>, List<ParsedCartesianPoint>> {
        protected final PointFieldType fieldType;

        PointIndexer(PointFieldType fieldType) {
            this.fieldType = fieldType;
        }

        public List<ParsedCartesianPoint> prepareForIndexing(List<ParsedCartesianPoint> points) {
            if (points == null || points.isEmpty()) {
                return Collections.emptyList();
            }
            return points;
        }

        public Class<List<ParsedCartesianPoint>> processedClass() {
            return List.class;
        }

        public List<IndexableField> indexShape(ParseContext context, List<ParsedCartesianPoint> points) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>(1);
            for (ParsedCartesianPoint point : points) {
                fields.add((IndexableField)new XYPointField(this.fieldType.name(), point.getX(), point.getY()));
            }
            return fields;
        }
    }

    public static class TypeParser
    extends AbstractPointGeometryFieldMapper.TypeParser<Builder> {
        protected Builder newBuilder(String name, Map<String, Object> params) {
            return new Builder(name);
        }

        protected AbstractPointGeometryFieldMapper.ParsedPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            ParsedCartesianPoint point = new ParsedCartesianPoint();
            CartesianPoint.parsePoint(nullValue, (CartesianPoint)point, ignoreZValue);
            if (!ignoreMalformed) {
                if (!Float.isFinite(point.getX())) {
                    throw new IllegalArgumentException("illegal x value [" + point.getX() + "]");
                }
                if (!Float.isFinite(point.getY())) {
                    throw new IllegalArgumentException("illegal y value [" + point.getY() + "]");
                }
            }
            return point;
        }
    }

    public static class Builder
    extends AbstractPointGeometryFieldMapper.Builder<Builder, PointFieldType> {
        public Builder(String name) {
            super(name, new FieldType());
            this.builder = this;
        }

        public PointFieldMapper build(Mapper.BuilderContext context, String simpleName, FieldType fieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, AbstractPointGeometryFieldMapper.ParsedPoint nullValue, FieldMapper.CopyTo copyTo) {
            PointFieldType ft = new PointFieldType(this.buildFullName(context), this.indexed, this.hasDocValues, this.meta);
            ft.setGeometryParser((AbstractGeometryFieldMapper.Parser)new AbstractPointGeometryFieldMapper.PointParser());
            ft.setGeometryIndexer(new PointIndexer(ft));
            ft.setGeometryQueryBuilder(new ShapeQueryPointProcessor());
            return new PointFieldMapper(simpleName, fieldType, (MappedFieldType)ft, multiFields, ignoreMalformed, (Explicit<Boolean>)this.ignoreZValue(context), nullValue, copyTo);
        }
    }
}

